package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.facade.NewsFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class NewsFallbackFactory implements FallbackFactory<NewsFacadeService> {
    @Override
    public NewsFacadeService create(Throwable throwable) {
        return new NewsFacadeService() {

            @Override
            public ResponseEntity<NewsBriefInfoDto> getBriefInfo(Long newsId, String areaCode, Long userId) {
                return ResponseEntity.ok(NewsBriefInfoDto.builder().build());
            }
        };
    }
}
