package com.bxm.localnews.user.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.facade.AdvertFeignService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AdvertIntegrationService extends BaseService {

    @Autowired
    private AdvertFeignService advertFeignService;

    @Autowired
    private BizIntegrationService bizIntegrationService;

    public void triggerAdvert(String androidId){
        advertFeignService.trigger(androidId);
    }

    /**
     * 保存android id，用于后续广告激活，详见localnews-thirdpart:AdvertCallbackServiceImpl
     */
    @Async
    public void triggerAndroidId(LoginInfo loginInfo, BasicParam basicParam) {
        if (logger.isDebugEnabled()) {
            logger.debug("创建安卓账号，触发广告回调，loginInfo:{}，platform:{}", JSON.toJSONString(loginInfo), basicParam.getPlatform());
        }
        if (AppConst.PLATFORM.ANDROID == basicParam.getPlatform()) {
            EquipmentDTO equipmentDTO = bizIntegrationService.getDevice(basicParam.getDevcId());
            if (null != equipmentDTO) {
                triggerAdvert(equipmentDTO.getAndroidId());
            }
        }
    }
}
