package com.bxm.localnews.user.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.facade.BizLogFeignService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

@Service
@Slf4j
public class BizLogIntegrationService {

    @Resource
    private BizLogFeignService bizLogFeignService;

    @Async
    @Deprecated
    public void createUser(User user, BasicParam basicParam, UserAccount userAccount) {
        BigDecimal totalCash = null == userAccount ? BigDecimal.ZERO : userAccount.getTotalCash();

        if (null == basicParam) {
            log.warn("基础参数为空，用户信息为：{}", JSON.toJSONString(user));
            basicParam = new BasicParam();
            basicParam.setChnl("EXCEPTION");
        }

        int platform = 0;

        if (basicParam.getPlatform() != 0) {
            platform = basicParam.getPlatform();
        } else if (null != user.getRegisterClient()) {
            platform = NumberUtils.parseToInt(user.getRegisterClient());
        }

        bizLogFeignService.newUser(user.getId(),
                basicParam.getChnl(),
                user.getToken(),
                totalCash,
                StringUtils.isNotEmpty(user.getRegisterChannel()) ? user.getRegisterChannel() : "0",
                null == user.getRelationId() ? null : user.getRelationId().toString(),
                platform);
    }

    @Deprecated
    public void login(Long userId, Integer platform) {
        bizLogFeignService.login(userId, platform);
    }

    @Deprecated
    public void changeGender(Long userId, int sex, Integer platform) {
        bizLogFeignService.changeGender(userId, sex, platform);
    }

    @Deprecated
    public void changeArea(Long userId, String areaCode, Integer platform) {
        bizLogFeignService.changeArea(userId, areaCode, platform);
    }

    @Deprecated
    public void inviteSuccessed(Long userId, Long invitedUserId, Integer platform) {
        bizLogFeignService.inviteSuccessed(userId, invitedUserId, platform);
    }

    /**
     * 数据埋点上报
     *
     * @param param 埋点参数
     */
    public void point(PointReportParam param) {
        Preconditions.checkArgument(null != param);
        bizLogFeignService.point(param);
    }
}
