package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.CommodityGoodsDTO;
import com.bxm.localnews.user.facade.CommodityFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * 商品服务的集成接口
 * 包括，但不限于：
 * 简化调用步骤或参数，使其适配当前业务场景
 * 进行容错的处理，第三方服务调用失败后的逻辑处理
 * 模型适配，将第三方的返回结果适配为当前服务需要的数据结构
 * @author liujia
 * @date 2020/05/14 14:53
 */
@Service
public class CommodityIntegrationService {

    private final CommodityFeignService commodityFeignService;

    @Autowired
    public CommodityIntegrationService(CommodityFeignService commodityFeignService) {
        this.commodityFeignService = commodityFeignService;
    }

    public CommodityGoodsDTO getBriefGoodsById(Long goodsId) {
        if (null == goodsId) {
            return null;
        }

        ResponseEntity<CommodityGoodsDTO> goods = commodityFeignService.getBriefGoodsById(goodsId.toString());
        if (goods.hasBody()) {
            return goods.getBody();
        }

        return null;
    }
}
