package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.facade.LocationFeignService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * 根据编码获取地区相关信息
 *
 * @author zhaoyadong 2019/3/1 14:00
 */
@Service
public class LocationIntegrationService {

    @Resource
    private LocationFeignService locationFeignService;

    private LoadingCache<String, LocationDTO> cache;

    public LocationDTO getLocationByGeocode(String code) {
        if (StringUtils.isBlank(code)) {
            return new LocationDTO();
        }

        if (cache == null) {
            initCache();
        }
        return cache.getUnchecked(code);
    }

    private void initCache() {
        cache = CacheBuilder.newBuilder()
                .expireAfterWrite(1, TimeUnit.MINUTES)
                .maximumSize(1000)
                .build(new CacheLoader<String, LocationDTO>() {
                    @Override
                    public LocationDTO load(String key) {
                        LocationDTO body = locationFeignService.getLocationByGeocode(key).getBody();

                        if (body == null) {
                            body = new LocationDTO();
                            body.setCode(key);
                        }
                        return body;
                    }
                });
    }
}
