package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.facade.MerchantFeignService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author pf.w
 * @date 2020/7/16 12:08
 */
@Slf4j
@Service
public class MerchantIntegrationService {

    @Resource
    MerchantFeignService merchantFeignService;

    public MerchantUserDTO getUserMerchantInfo(Long userId) {

        try {
            ResponseEntity<MerchantUserDTO> entity = merchantFeignService.userMerchantInfo(userId);

            if (entity.hasBody()) {
                return entity.getBody();
            } else {
                MerchantUserDTO merchantUserDTO = new MerchantUserDTO();
                merchantUserDTO.setUserId(userId);
                merchantUserDTO.setMerchantStatus(0);
                return merchantUserDTO;
            }
        } catch(Exception e) {
            log.error("调用商家模块获取商家信息失败, userId: {}", userId, e);
        }

        return null;
    }
}
