package com.bxm.localnews.user.integration;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.integration.MessageIntegrationService;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * @author zhaoyadong 2019/3/1 10:11
 * @desc
 */
@Service
public class MessageUserIntegrationService extends BaseService {

    @Resource
    private MessageIntegrationService messageIntegrationService;

    @Resource
    private MessageSender messageSender;

    @Resource
    private DomainIntegrationService domainIntegrationService;

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);

        messageSender.sendUserMessage(pushMessage);
    }

    public Long getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {
        Map<String, Long> map = messageIntegrationService.getUnreadMap(userId, messageType);

        return map.get(messageType.name());
    }

    /**
     * 新增粉丝时，同步到消息服务，给用户个人消息中显示
     *
     * @param userId 对应的用户ID
     */
    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("新增粉丝");
        pushMessage.setContent("粉丝+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());

        addMessage(pushMessage, userId);
    }

    /**
     * 添加金币消息
     */
    public void addGoldMsg(GoldFlow goldFlow, Integer usableGold) {
        String reason;
        if (StringUtils.isNotBlank(goldFlow.getContent())) {
            reason = goldFlow.getContent();
        } else {
            reason = goldFlow.getRemark();
        }

        String title;
        if (goldFlow.getAmount() > 0) {
            title = "账户余额因" + reason + "增加" + Math.abs(goldFlow.getAmount())
                    + "朵花，目前共有" + usableGold + "朵小红花啦！";
        } else {
            title = "账户余额因" + reason + "扣除" + Math.abs(goldFlow.getAmount())
                    + "朵花，目前剩余 " + usableGold + "朵小红花";
        }

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        info.setProtocol(genPointUrlProtocol(goldFlow.getUserId()));

        PushMessage message = PushMessage.build();
        message.setTitle("通知消息");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);

        message.assign(goldFlow.getUserId());

        this.addMessage(message, goldFlow.getUserId());
    }

    /**
     * 访问积分商城的地址
     *
     * @param userId 用户ID
     * @return 积分商城直接访问的地址，服务端进行最终访问地址的处理，然后重定向
     */
    private String genPointUrlProtocol(Long userId) {
        String pointUrl = domainIntegrationService.getServerHostBaseUrl() + "/api/public/points/url?userId=" + userId;
        return "wst://web/webDetail?url=" + UriUtils.encode(pointUrl, Charset.defaultCharset());
    }
}
