package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.ImgDTO;
import com.bxm.localnews.user.dto.NoteDTO;
import com.bxm.localnews.user.dto.UserImgDTO;
import com.bxm.localnews.user.facade.UserNewsFeignService;
import com.bxm.localnews.user.vo.UserLikeVo;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 对facade接口进行二次封装，用于适配和兼容
 *
 * @author liujia
 */
@Service
public class UserNewsIntegrationService extends BaseService {

    @Autowired
    private UserNewsFeignService userNewsFeignService;

    @Async
    public void initUserNewsImage(Long newUserId, Long defaultUserId) {
        userNewsFeignService.initUserImage(newUserId, defaultUserId);
    }

    public Integer getPublishPostNum(Long userId) {
        return userNewsFeignService.getPublishPostNum(userId);
    }

    public List<UserLikeVo> getLikeNumByUserIds(List<Long> userId) {
        ResponseEntity<List<UserLikeVo>> result = userNewsFeignService.getLikeNumByUserIds(userId);
        if (Objects.nonNull(result)) {
            return result.getBody();
        }
        return Lists.newArrayList();
    }

    public Boolean verifySensitiveWord(String text) {
        ResponseEntity<Boolean> isSensitiveEntity = userNewsFeignService.verifySensitiveWord(text);
        return isSensitiveEntity.getBody();
    }

    public Map<Long, List<ImgDTO>> batchGetUserImg(List<Long> userIdList) {
        Map<Long, List<ImgDTO>> imgMap = new HashMap<>();
        ResponseEntity<List<UserImgDTO>> userImgListEntity = userNewsFeignService.batchGetUserImg(userIdList, null);
        List<UserImgDTO> userImgDTOList = userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty(userImgDTOList)) {
            userImgDTOList.forEach(e -> {
                //大于4张的显示4张，小于4张的不显示
                if (e.getImgDtoList().size() >= 4) {
                    imgMap.put(e.getUserId(), subImgList(e.getImgDtoList(), 4));
                }
            });
        }
        return imgMap;
    }

    public Map<Long, List<ImgDTO>> batchGetAllUserImg(List<Long> userIdList, Long userId) {
        Map<Long, List<ImgDTO>> imgMap = new HashMap<>();
        ResponseEntity<List<UserImgDTO>> userImgListEntity = userNewsFeignService.batchGetUserImg(userIdList, userId);
        List<UserImgDTO> userImgDTOList = userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty(userImgDTOList)) {
            userImgDTOList.forEach(e -> {
                imgMap.put(e.getUserId(), subImgList(e.getImgDtoList(), 4));

            });
        }
        return imgMap;
    }

    public Map<Long, NoteDTO> batchGetUserNote(List<Long> userIdList, Long userId) {
        Map<Long, NoteDTO> noteMap = new HashMap<>();
        ResponseEntity<List<NoteDTO>> userNoteEntity = userNewsFeignService.batchGetUserNote(userIdList, userId);
        List<NoteDTO> noteDTOList = userNoteEntity.getBody();
        if (!CollectionUtils.isEmpty(noteDTOList)) {
            noteDTOList.forEach(e -> {
                noteMap.put(e.getUserId(), e);

            });
        }
        return noteMap;
    }

    private List<ImgDTO> subImgList(List<ImgDTO> imgDTOList, int limit) {
        if (imgDTOList.size() >= limit) {
            return imgDTOList.subList(0, limit);
        } else {
            return imgDTOList;
        }
    }


}
