package com.bxm.localnews.user.model.entity;

import com.bxm.localnews.common.vo.IUserIdSharding;
import lombok.Data;

import java.util.Date;

/**
 * a_user_talent_invite_record
 *
 * @author
 */
@Data
public class UserTalentInviteEntity implements IUserIdSharding {
    /**
     * 主键
     */
    private Long id;

    /**
     * 发起邀请达人ID
     */
    private Long inviteUserId;

    /**
     * 被邀请普通用户ID（用户注册后补全）
     */
    private Long userId;

    /**
     * 唯一编码（如微信uid）
     */
    private String uniqueCode;

    /**
     * 被邀请普通用户名称
     */
    private String invitedUserName;

    /**
     * 被邀请普通用户头像
     */
    private String invitedUserImg;

    /**
     * 邀请途径（类型）（新闻、活动、小程序、VIP等）
     */
    private String type;

    /**
     * 发起邀请时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}