package com.bxm.localnews.user.model.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_user_talent_invite_history
 *
 * @author
 */
@Data
public class UserTalentInviteHistoryEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 达人用户id
     */
    private Long userId;

    /**
     * 上级达人用户ID
     */
    private Long inviteUserId;

    /**
     * 达人真实姓名
     */
    private String realName;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 成为达人方式：0用户邀请成为达人，1管理后台直接升级
     */
    private Integer type;

    /**
     * 上级达人的上级达人用户id
     */
    private Long inviteSuperUserId;

    /**
     * 团队人数
     */
    private Integer groupCount;

    /**
     * 自购订单数量
     */
    private Integer purchaseOrderCount;

    /**
     * 分享订单数
     */
    private Integer shareOrderCount;

    /**
     * 自购收益
     */
    private BigDecimal purchaseProfile;

    /**
     * 分享收益
     */
    private BigDecimal shareProfile;

    /**
     * 团队收益
     */
    private BigDecimal groupProfile;

    /**
     * 团队订单数量
     */
    private Integer groupOrderCount;

    /**
     * 向上级贡献金额
     */
    private BigDecimal superiorProfile;

    /**
     * 向上上级贡献金额
     */
    private BigDecimal onSuperiorProfile;

    /**
     * 向上级贡献订单数量
     */
    private Integer superiorOrderCount;

    /**
     * 向上上级贡献订单数量
     */
    private Integer onSuperiorOrderCount;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}