package com.bxm.localnews.user.model.vo.talent;

import com.bxm.localnews.user.model.constants.CommonConstants;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/12/10 11:19 上午
 */
@Data
@ApiModel("团队达人信息列表")
public class TalentGroupListVO {
    @ApiModelProperty("用户id")
    private Integer userId;

    @ApiModelProperty("用户名称")
    private String username;

    @ApiModelProperty("注册时间，日期已经格式化，可直接使用")
    @JsonFormat(pattern = CommonConstants.DATE_FORMAT_TALENT_REGISTER)
    private Date registerTime;

    @ApiModelProperty("贡献订单数量")
    private Integer contributeOrderCount;

    @ApiModelProperty("贡献收益")
    private BigDecimal contributeAmount;

    @ApiModelProperty("团队规模")
    private Integer groupCount;
}