package com.bxm.localnews.user.properties;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author zhaoyadong 2019/3/9 13:41
 * @desc
 */
@Data
@Component
@ConfigurationProperties("common.config")
public class CommonProperties {

    /**
     * 万事通默认图标
     */
    private String appIconUrl;

    /**
     * 应用名称
     */
    private String appName = "本地万事通";


    /**
     * 推广赚钱地址 path
     */
    private String linkPath = "inviteRecords.html?userId={userId}&cityName={areaName}&code={areaCode}";

    /**
     * 创蓝短信appid与解密密钥的对应关系
     */
    private Map<String, String> chuanglanAppIdDes = Maps.newHashMap();

    /**
     * 创蓝闪验平台与appid
     */
    private Map<Integer, String> chuanglanAppId = Maps.newHashMap();

    /**
     * 创蓝闪验加密私钥
     */
    private String chuanglanPrivateKey;

    /**
     * 模拟用户手机号码
     */
    private String chuanglanMockPhone;

    /**
     * 饿了么图标地址
     */
    private String eleIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1DJ7YNNEKZ.png";
    /**
     * kfc图标地址
     */
    private String kfcIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1XSIZNNEK01.png";
    /**
     * 美团图标地址
     */
    private String meituanIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML14K40ONEK11.png";
    /**
     * 卡券图标地址
     */
    private String cardIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML13XQ0ONEK21.png";
    /**
     * 淘宝图标地址
     */
    private String tbIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML17OD1ONEK31.png";
    /**
     * 团购图标地址
     */
    private String groupIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML19KE2ONEK41.png";
    /**
     * 团油团标地址
     */
    private String oilIconUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1OH13ONEK51.png";

    /**
     * 饿了么订单封面图片地址
     */
    private String eleCoverImgUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1SDCFXNEKK1.png";

    /**
     * 美团订单封面图片地址
     */
    private String meiTuanCoverImgUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1377DXNEKG1.png";

    /**
     * 肯德基订单封面图片地址
     */
    private String kfcCoverImgUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML12TODXNEKH1.png";

    /**
     * 团油订单封面图片地址
     */
    private String oilCoverImgUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1827EXNEKI1.png";

    /**
     * 卡券订单封面图片地址
     */
    private String cardCoverImgUrl = "https://mtest.wstong.com/localnews_test/png/20200904/H8UKWHWUDDXIWC6YX36BXAZ72VML1YOWEXNEKJ1.png";

    /**
     * vip标题icon
     */
    private String vipIconUrl = "https://m.wstong.com/localnews_prod/png/20201217/KC866271PBPLDAGTWYPG61JI307J24I9L6SIK2R.png";

    /**
     * vip列表图片
     */
    private String vipImgUrl = "https://m.wstong.com/localnews_prod/png/20201217/KC866271PBPLDAGTWYPG61JI307J2NF7M6SIK5R.png";
    /**
     * 平台奖励小标
     */
    private String platFromIconUrl = "https://m.wstong.com/localnews_prod/png/20201217/KC866271PBPLDAGTWYPG61JI307J2HZNM6SIK7R.png";
    /**
     * 平台奖励金列表图片
     */
    private String platFromImgUrl = "https://m.wstong.com/localnews_prod/png/20201217/KC866271PBPLDAGTWYPG61JI307J2F48N6SIK8R.png";


    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 推广渠道链接H5path
     */
    private String channelPath = "/register.html?inviteUserId=";

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

    /**
     * 公众号常见问题达人跳转
     */
    private String officialAccountsFaqTalentJumpUrl = "http://mp.weixin.qq.com/s?__biz=MzUwOTg5NTQwNA==&mid=100000011&idx=1&sn=d680ba599bd2c9b7289c79454da4efc3&chksm=790a76884e7dff9ee154039703124d44a9f3b3d7ab38f09365780960cb229c63ebe800a825f8#rd";

    /**
     * 公众号常见问题非达人跳转
     */
    private String officialAccountsFaqNoTalentJumpUrl = "http://mp.weixin.qq.com/s?__biz=MzUwOTg5NTQwNA==&mid=100000004&idx=1&sn=ae0594216d1f54a97fc27abe5ce5527e&chksm=790a76874e7dff9193098f466a0bff51cbb92b62ea538289fce2f52d45f4c44e8a2274e01936#rd";
    /**
     * 公众号新手引导非达人跳转
     */
    private String noviceGuideUrlNoTalentJumpUrl = "http://mp.weixin.qq.com/s?__biz=MzUwOTg5NTQwNA==&mid=100000011&idx=1&sn=d680ba599bd2c9b7289c79454da4efc3&chksm=790a76884e7dff9ee154039703124d44a9f3b3d7ab38f09365780960cb229c63ebe800a825f8#rd";

    /**
     * 公众号新手引导达人跳转
     */
    private String noviceGuideUrlTalentJumpUrl = "http://mp.weixin.qq.com/s?__biz=MzUwOTg5NTQwNA==&mid=100000007&idx=1&sn=a3debc018b104107993c0ec03d680e16&chksm=790a76844e7dff928321ac49f7d8d773425c97c489d612bd424ab7a26d3b7fb8c917de5a9d53#rd";

    /**
     * vip开卡跳转
     */
    private String openingVipJumpUrl = "member.html#/wx/card?inviteCode={inviteCode}";
}
