package com.bxm.localnews.user.model.param.talent;

import com.bxm.newidea.component.constraints.MobilePhoneNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 达人注册入参
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/10 11:49 上午
 */
@Data
@ApiModel("达人注册入参")
public class TalentRegisterParam {

    @NotNull(message = "注册用户id不能为空")
    @ApiModelProperty(value = "注册用户id", required = true)
    private Long registerUserId;

    @NotNull(message = "邀请用户id不能为空")
    @ApiModelProperty(value = "邀请用户id", required = true)
    private Long inviteUserId;

    @NotBlank(message = "真实姓名不能为空")
    @ApiModelProperty(value = "真实姓名", required = true)
    private String realName;

    @NotBlank(message = "电话号码不能为空")
    @MobilePhoneNumber
    @ApiModelProperty(value = "电话号码", required = true)
    private String phone;
}