package com.bxm.localnews.user.model.vo.earnings;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lowi
 * @date 2020/12/11 10:04
 */
@Data
@ApiModel("我的收益返回类")
@Builder
public class UserEarningsListVO {

    @ApiModelProperty("收益类型  购买的类型")
    private Integer earningsType;

    @ApiModelProperty("收益类型的图片")
    private String earningsTypeImg;

    @ApiModelProperty("收益类型描述")
    private String earningsTypeDesc;

    @ApiModelProperty("收益标题")
    private String earningsTitle;

    @ApiModelProperty("订单状态")
    private Integer status;

    @ApiModelProperty("订单状态描述")
    private String statusDesc;

    @ApiModelProperty("订单的图片")
    private String img;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date orderTime;

    @ApiModelProperty("* 金额展示类型 1: 展示为 自购| 佣金 ￥100\n" +
            "     * 2: 展示为 购买人：刘亦菲 电话：1312333211 佣金：￥100\n" +
            "     * 3: 展示为 佣金：￥100\n" +
            "     * 4: 展示为 被邀请人 | 佣金：￥100")
    private Integer cashShowType;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("不是自购才展示  购买用户的id")
    private Long sellUserId;

    @ApiModelProperty("cashShowType = 2 才展示  购买用户的名称")
    private String sellUserName;

    @ApiModelProperty("cashShowType = 2 才展示  购买用户的手机号")
    private String sellUserPhone;

    @ApiModelProperty("佣金")
    private BigDecimal money;

    @ApiModelProperty("订单的商品ID 收益类型为商品返佣时 跳转使用")
    private Long goodsId;


}
