package com.bxm.localnews.user.model.vo.hotpost;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/12 5:13 下午
 */
@Data
@ApiModel("热文帖子排行榜信息VO")
public class HotPostRankInfoVO {

    @ApiModelProperty("当前用户是否进入排行榜")
    private Boolean onRank;

    @ApiModelProperty("排行榜用户列表")
    private List<HotPostAwardUserVO> rankUserList;

    @ApiModelProperty("当前用户在排行榜的排名，如果onRank为false则，当前对象为null")
    private HotPostAwardMyUserVO myRankInfo;

    @ApiModelProperty("上榜攻略帖子id")
    private Long rankStrategyPostId;
}