package com.bxm.localnews.user.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component
@ConfigurationProperties("user.config")
@Data
public class UserProperties {

    /**
     * 微信信息同步超时时间
     */
    private long wechatSyncTimeout;

    /**
     * 金币流水记录开关
     */
    private boolean flowSwitch;

    /**
     * 用户默认头像
     */
    private String defaultHeadImgUrl;

    /**
     * 用户生成token时的appKey
     */
    private String appKey;

    /**
     * 金币兑换率
     */
    private BigDecimal goldRate = BigDecimal.valueOf(1000);

    /**
     * 当天限制提现金额
     */
    private BigDecimal todayLimitBalance = BigDecimal.valueOf(10);

    /**
     * 每笔提现最低金额
     */
    private BigDecimal mixWithdrawBalance = BigDecimal.valueOf(0.3);

    /**
     * 每笔提现最大金额
     */
    private BigDecimal maxWithdrawBalance = BigDecimal.valueOf(10);

    /**
     * 新用户邀请奖励 500朵小红花
     */
    private Integer newUserGold = 500;

    /**
     * 老用户邀请奖励3朵小红花
     */
    private Integer oldUserGold = 3;

    /**
     * 线下推广赏金
     */
    private BigDecimal bountyOffline;

    /**
     * 本地人列表引导完善资料卡片文案
     */
    private String nativeNewbieGuideText = "完善个人信息，让更多人认识你";

    /**
     * 本地人列表引导完善资料个人简介
     */
    private String nativeNewbieGuidePersonalProfile = "未填写个人介绍";

    /**
     * 本地人列表引导完善资料卡片位置
     */
    private Integer nativeNewbieGuidePosition = 2;

    /**
     * 引导完善资料阈值
     */
    private Integer nativeNewbieGuideThreshold = 80;

    /**
     * 个人资料页面小红花提示
     */
    private String infoCompleteTaskText = "首次完成资料赠送30朵小红花";

    /**
     * 风险用户识别开关
     * 默认关闭
     */
    private Boolean riskCheckSwitch = Boolean.FALSE;

    /**
     * 邀请好友的滚动弹幕列表
     */
    private List<String> inviteScrollList = Lists.newArrayList();

    /**
     * 城市显示人数的基数
     */
    private Integer virtualTotalBase = 10000;

    /**
     * 城市显示人数的倍数
     */
    private Integer virtualMultiple = 11;

    /**
     * 商家下架的情况下，是否仍然强制显示商家信息
     */
    private Boolean forceShowMerchant = true;

    /**
     * 虚拟用户登录返回一个虚假的手机号
     */
    private String virtualUserPhone = "12111221122";

    /**
     * 开放邀请的现金奖励活动
     */
    private List<String> openActivityAreaCodes = Lists.newArrayList();

    /**
     * 开通区域的限定子区域
     */
    private Map<String, String> subAreaCodeMap = Maps.newHashMap();

    /**
     * 开启活动对IP地址的校验，允许的IP范围
     * key: 地区编码
     * value：省份要求
     */
    private Map<String, String> activityAreaIpProvinceMapping = Maps.newHashMap();

    /**
     * 开启活动对IP地址的校验，允许IP的城市范围
     * key: 地区编码
     * value：城市要求
     */
    private Map<String, String> activityAreaIpCityMapping = Maps.newHashMap();

    /**
     * 活动期间邀请用户获得的奖励
     */
    private BigDecimal activityInviteAward = new BigDecimal("2");

    /**
     * 活动期间邀请用户发帖获取的奖励
     */
    private BigDecimal activityInvitePostAward = new BigDecimal("1");

    /**
     * 是否启用风控规则
     */
    private Boolean enableRiskFilter = false;

}
