/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.CashFlowMapper;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.service.CashFlowService;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CashFlowServiceImpl
extends BaseService
implements CashFlowService {
    @Autowired
    private CashFlowMapper cashFlowMapper;

    @Override
    public List<UserDayCashDTO> getRecentSevenDayCashFlowByUser(Long userId) {
        return this.cashFlowMapper.querySevenDayCashFlows(userId);
    }

    @Override
    public List<CashFlowDTO> getUserAllCashFlow(CashFlowParam cashFlowParam) {
        if (StringUtils.isNotEmpty((CharSequence)cashFlowParam.getDate())) {
            Date date = DateUtils.parse((String)cashFlowParam.getDate());
            Date endDate = DateUtils.addField((Date)date, (int)5, (int)1);
            cashFlowParam.setEndDate(DateUtils.formatAtWill((Date)endDate, (String)"yyyy-MM-dd"));
            cashFlowParam.setType("income");
        } else {
            cashFlowParam.setType(null);
        }
        List cashFlowList = this.cashFlowMapper.queryCashFlows(cashFlowParam);
        return this.generateCashFlowDTO(cashFlowList);
    }

    private List<CashFlowDTO> generateCashFlowDTO(List<CashFlow> cashFlows) {
        List<Object> cashFlowDTOS = Lists.newArrayList();
        if (CollectionUtils.isEmpty(cashFlows)) {
            return cashFlowDTOS;
        }
        cashFlowDTOS = cashFlows.stream().map(this::convertCashFlow).collect(Collectors.toList());
        return cashFlowDTOS;
    }

    private CashFlowDTO convertCashFlow(CashFlow cashFlow) {
        CashFlowDTO cashFlowDTO = new CashFlowDTO();
        cashFlow.setAmount(cashFlow.getAmount().setScale(2, 4));
        String amount = "";
        if (cashFlow.getAmount().compareTo(BigDecimal.ZERO) == 1) {
            amount = "+" + cashFlow.getAmount();
            cashFlowDTO.setPlus(Boolean.TRUE);
        } else {
            amount = cashFlow.getAmount().toString();
            cashFlowDTO.setPlus(Boolean.FALSE);
        }
        cashFlowDTO.setAmount(amount);
        cashFlowDTO.setCreateTime(cashFlow.getCreateTime());
        cashFlowDTO.setTypeDesc(CashFlowTypeEnum.valueOf((String)cashFlow.getType()).getDesc());
        return cashFlowDTO;
    }

    @Override
    public int addCashFlow(CashFlow cashFlow) {
        this.logger.debug("\u65b0\u589e\u6d41\u6c34\uff1a{}", (Object)cashFlow);
        return this.cashFlowMapper.addCashFlow(cashFlow);
    }

    @Override
    public BigDecimal getMySelfBounty(Long userId) {
        BigDecimal myBounty = this.cashFlowMapper.getMySelfBounty(userId);
        return myBounty == null ? BigDecimal.ZERO : myBounty;
    }

    @Override
    public BigDecimal getMyRedPacket(Long userId) {
        BigDecimal myRedPacket = this.cashFlowMapper.getMyRedPacket(userId);
        return myRedPacket == null ? BigDecimal.ZERO : myRedPacket;
    }
}

