/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.SignWarper;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.SignIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserBaseInfoServiceImpl
extends BaseService
implements UserBaseInfoService {
    @Resource
    RedisStringAdapter redisStringAdapter;
    @Resource
    private UserMapper userBaseInfoMapper;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private SignIntegrationService signIntegrationService;
    @Resource
    private UserProperties userProperties;
    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;
    @Resource
    private MessageUserIntegrationService messageUserIntegrationService;

    @Override
    public UserBaseInfoDTO getUserInfoForWST(Long userId, int platform) {
        if (null == userId) {
            this.logger.error("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        User user = this.userBaseInfoMapper.selectByUserId(userId.longValue());
        if (null != user) {
            SignWarper signWarper = this.signIntegrationService.listSignRecord(userId, platform);
            int count = this.vipIntegrationService.countVipByUser(userId);
            UserAccount userAccount = this.userAccountService.getUserAccountDetail(userId);
            UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
            if (userAccount != null) {
                BigDecimal usableGold = new BigDecimal(userAccount.getUsableGold());
                userBaseInfoDTO.setGoldNum(usableGold.compareTo(BigDecimal.ZERO) == 0 ? null : Integer.valueOf(userAccount.getUsableGold()));
            }
            userBaseInfoDTO.setNickname(StringUtils.isBlank((CharSequence)user.getNickname()) ? StringUtils.hideMobile((String)user.getPhone()) : user.getNickname());
            userBaseInfoDTO.setHeadImg(StringUtils.isBlank((CharSequence)user.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
            userBaseInfoDTO.setInviteNum(Integer.valueOf(count));
            userBaseInfoDTO.setPhone(user.getPhone());
            userBaseInfoDTO.setSignWarper(signWarper);
            userBaseInfoDTO.setMaterialFinished(this.checkCompleteInfo(user.getId()));
            KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey((Object)userId);
            Boolean redPoint = (Boolean)this.redisStringAdapter.get(redPointKey, Boolean.class);
            if (redPoint == null) {
                redPoint = Boolean.FALSE;
            }
            userBaseInfoDTO.setRedPoint(redPoint.booleanValue());
            int msgCount = this.messageUserIntegrationService.countTotalMsg(userId);
            userBaseInfoDTO.setNoticeNum(Integer.valueOf(msgCount));
            return userBaseInfoDTO;
        }
        return null;
    }

    private boolean checkCompleteInfo(Long userId) {
        return this.noviceTaskRecordService.isTaskCompleted(userId, TaskEnum.TASK_IMPROVE_INFO.getDesc());
    }
}

