/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.user.config.WithdrawConfig;
import com.bxm.localnews.user.domain.WithdrawMapper;
import com.bxm.localnews.user.dto.WithdrawConfigDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.enums.WithdrawTypeEnum;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserWithdrawService;
import com.bxm.localnews.user.service.WithdrawService;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserWithdrawServiceImpl
extends BaseService
implements UserWithdrawService {
    private WithdrawConfig withdrawConfig;
    private UserAccountService userAccountService;
    private WithdrawService withdrawService;
    private WithdrawMapper withdrawMapper;

    @Autowired
    public UserWithdrawServiceImpl(WithdrawConfig withdrawConfig, UserAccountService userAccountService, WithdrawService withdrawService, WithdrawMapper withdrawMapper) {
        this.withdrawConfig = withdrawConfig;
        this.userAccountService = userAccountService;
        this.withdrawService = withdrawService;
        this.withdrawMapper = withdrawMapper;
    }

    @Override
    public BigDecimal userWithdraw(Long userId, BigDecimal amount) {
        return amount;
    }

    @Override
    public WithdrawDTO getWithDrawList(Long userId) {
        WithdrawDTO withdrawDTO = new WithdrawDTO();
        UserAccount userAccount = this.userAccountService.getUserAccountDetail(userId);
        withdrawDTO.setAvailableCash(userAccount.getDrawablelCash());
        WithdrawFlow withdrawFlow = this.withdrawService.getUserWithdrawFlow(userId);
        if (withdrawFlow != null && WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState())) {
            if ("V2_ACCOUNT_SIMPLE_BAN".equals(withdrawFlow.getRemark())) {
                withdrawDTO.setFailMsg("\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u5b9e\u540d\u8ba4\u8bc1\u540e\u518d\u63d0\u73b0");
            } else {
                withdrawDTO.setFailMsg("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
        }
        if (BigDecimal.ZERO.compareTo(userAccount.getWithdrawalCash()) == 0) {
            withdrawDTO.setWithdrawConfigDTOList(this.withdrawConfig.getNotWithdrawList());
        } else {
            ArrayList withdrawDTOList = Lists.newArrayList();
            withdrawDTOList.addAll(this.withdrawConfig.getHavingWithdrawList());
            this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u5df2\u63d0\u73b0\u91d1\u989d\u4e3a[{}]", (Object)userId, (Object)userAccount.getWithdrawalCash());
            if (userAccount.getWithdrawalCash().compareTo(BigDecimal.TEN) != -1) {
                WithdrawConfigDTO withdrawConfigDTO = (WithdrawConfigDTO)withdrawDTOList.get(0);
                withdrawConfigDTO.setWithdrawNumber(Integer.valueOf(1));
                if (withdrawFlow == null) {
                    withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                } else {
                    List<WithdrawFlow> withdrawFlowList = this.withdrawService.getUserTodayWithdraw(userId, WithdrawEnum.SUCCESS_PAYMENT.getState());
                    if (CollectionUtils.isEmpty((Collection)withdrawDTOList)) {
                        withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                    } else {
                        Optional<WithdrawFlow> successWithdrawFlow = withdrawFlowList.stream().filter(withdraw -> withdraw.getAmount().compareTo(BigDecimal.valueOf(2L)) == 0).findFirst();
                        if (successWithdrawFlow.isPresent()) {
                            withdrawConfigDTO.setEnableWithdraw(Boolean.valueOf(false));
                        } else {
                            withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                        }
                    }
                }
            }
            withdrawDTO.setWithdrawConfigDTOList((List)withdrawDTOList);
        }
        return withdrawDTO;
    }

    private Boolean isToday(Date date) {
        return DateUtils.formatAtWill((Date)new Date(), (String)"yyyy-MM-dd").equals(DateUtils.formatAtWill((Date)date, (String)"yyyy-MM-dd"));
    }

    private void withDraw(Long userId, BigDecimal amount) {
        WithdrawFlow withdrawFlow = new WithdrawFlow();
        Long id = this.nextSequence();
        withdrawFlow.setId(id);
        withdrawFlow.setOrderNo(this.generateWithdrawNum());
        withdrawFlow.setPayChannel(this.getWithdrawChannel());
        withdrawFlow.setUserId(userId);
        withdrawFlow.setState(WithdrawEnum.AUDIT.getState());
        withdrawFlow.setAmount(amount);
        Date now = new Date();
        withdrawFlow.setCreateTime(now);
        withdrawFlow.setUpdateTime(now);
        this.withdrawMapper.addWithdrawFlow(withdrawFlow);
        this.updateUserAccount(userId, amount, id);
    }

    private void updateUserAccount(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, new BigDecimal("-" + award), relationId, CashFlowTypeEnum.WECHAT_WITHDRAWAL.name(), null);
        this.userAccountService.addCash(accountCashParam);
    }

    private String generateWithdrawNum() {
        String prefix = WithdrawTypeEnum.getNameByType((Byte)WithdrawTypeEnum.WX_WITHDRAW.getType());
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private Long getWithdrawChannel() {
        return WithdrawTypeEnum.WX_WITHDRAW.getId();
    }
}

