package com.bxm.localnews.user.config;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

import javax.annotation.PostConstruct;

import com.bxm.localnews.user.dto.WithdrawConfigDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/7 21:53
 * @desc
 */
@Component
public class WithdrawConfig {

    /**
     * 未提现的配置列表
     **/
    private List<WithdrawConfigDTO> notWithdrawList = Lists.newArrayList();

    /**
     * 已提现的配置列表
     **/
    private List<WithdrawConfigDTO> havingWithdrawList = Lists.newArrayList();

    /**
     * 提现列表
     */
    private Set<BigDecimal> withdrawSet = Sets.newHashSet();

    @PostConstruct
    public void init() {
        WithdrawConfigDTO notWithdrawConfig = new WithdrawConfigDTO();
        BigDecimal newUserAward = BigDecimal.ONE;
        notWithdrawConfig.setAmount(newUserAward);
        notWithdrawList.add(notWithdrawConfig);
        notWithdrawList.addAll(genateWithdrawConfig());
        withdrawSet.add(newUserAward);

        WithdrawConfigDTO havingWithdrawConfig = new WithdrawConfigDTO();
        BigDecimal withdrawAward = new BigDecimal("2");
        withdrawSet.add(withdrawAward);
        havingWithdrawConfig.setAmount(withdrawAward);
        havingWithdrawList.add(havingWithdrawConfig);
        havingWithdrawList.addAll(genateWithdrawConfig());
    }

    private List<WithdrawConfigDTO> genateWithdrawConfig() {
        List<WithdrawConfigDTO> withdrawConfigDTOList = Lists.newArrayList();
        WithdrawConfigDTO withdrawConfig = new WithdrawConfigDTO();
        BigDecimal award = new BigDecimal("15");
        withdrawConfig.setAmount(award);
        withdrawSet.add(award);
        withdrawConfigDTOList.add(withdrawConfig);
        withdrawConfig = new WithdrawConfigDTO();
        award = new BigDecimal("30");
        withdrawConfig.setAmount(award);
        withdrawSet.add(award);
        withdrawConfigDTOList.add(withdrawConfig);
        withdrawConfig = new WithdrawConfigDTO();
        award = new BigDecimal("50");
        withdrawConfig.setAmount(award);
        withdrawSet.add(award);
        withdrawConfigDTOList.add(withdrawConfig);
        withdrawConfig = new WithdrawConfigDTO();
        award = new BigDecimal("100");
        withdrawConfig.setAmount(award);
        withdrawSet.add(award);
        withdrawConfigDTOList.add(withdrawConfig);
        withdrawConfig = new WithdrawConfigDTO();
        award = new BigDecimal("200");
        withdrawConfig.setAmount(award);
        withdrawSet.add(award);
        withdrawConfigDTOList.add(withdrawConfig);

        return withdrawConfigDTOList;
    }

    public List<WithdrawConfigDTO> getHavingWithdrawList() {
        return this.havingWithdrawList;
    }

    public List<WithdrawConfigDTO> getNotWithdrawList() {
        return this.notWithdrawList;
    }

    public Set<BigDecimal> getWithdrawSet() {
        return this.withdrawSet;
    }
}
