package com.bxm.localnews.user.service;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.vo.CashFlow;

/**
 * @author zhaoyadong 2019/3/5 22:12
 * @desc
 */
public interface CashFlowService {

    /**
     * 获取用户最近7天的每天收入信息
     *
     * @param userId
     * @return
     */
    List<UserDayCashDTO> getRecentSevenDayCashFlowByUser(Long userId);

    List<CashFlowDTO> getUserAllCashFlow(CashFlowParam cashFlowParam);

    int addCashFlow(CashFlow cashFlow);

    /**
     * 获取账户自己的赏金金额
     *
     * @param userId
     * @return
     */
    BigDecimal getMySelfBounty(Long userId);

    BigDecimal getMyRedPacket(Long userId);
}
