package com.bxm.localnews.user.service;

import com.bxm.localnews.user.dto.BountyDTO;
import com.bxm.localnews.user.dto.UserPayPromoteDTO;
import com.bxm.localnews.user.vo.InviteRecord;

import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/5 22:13
 * @desc
 */
public interface InviteRecordService {

    /**
     * 获取用户未到账金额详情
     *
     * @param userId
     * @return
     */
    BountyDTO getUserBountyInfo(Long userId);

    /**
     * 获取推广赚钱信息
     *
     * @param userId
     * @return
     */
    UserPayPromoteDTO getUserPayPromote(Long userId);

    /**
     * 添加邀请关系
     *
     * @param inviteUserId  邀请人id
     * @param invitedUserId 受邀人id
     * @param type          邀请途径
     * @return
     */
    Long addInviteRecord(Long inviteUserId, Long invitedUserId, String type);

    /**
     * 更新邀请关系金额
     *
     * @param inviteUserId  邀请人id
     * @param invitedUserId 受邀人id
     * @param cash          邀请金额
     * @return
     */
    Long updateInviteCash(Long inviteUserId, Long invitedUserId, BigDecimal cash);

    /**
     * 根据邀请人和受邀人获取邀请关系
     *
     * @param inviteUserId  邀请人用户id
     * @param invitedUserId 受邀人用户id
     * @return
     */
    InviteRecord getInviteRecordByInvitedUser(Long inviteUserId, Long invitedUserId);

    /**
     * 更新用户邀请关系
     *
     * @param inviteRecord
     * @return
     */
    Boolean updateInviteRecord(InviteRecord inviteRecord);

    /**
     * 根据邀请人和id获取邀请关系
     *
     * @param inviteUserId  邀请人用户id
     * @param id 邀请关系id
     * @return
     */
    InviteRecord getInviteRecordById(Long inviteUserId, Long id);
}
