package com.bxm.localnews.user.service;

import java.math.BigDecimal;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserRedPacketDTO;

/**
 * @author zhaoyadong 2019/3/8 14:38
 * @desc
 */
public interface RedPacketService {

    /**
     * 用户领取红包
     *
     * @param userId
     * @param basicParam
     * @return
     */
    Json<BigDecimal> userRecieveRedPacket(Long userId, BasicParam basicParam, String areaCode);

    /**
     * 用户是否可以领取红包
     *
     * @param basicParam
     * @param userId
     * @param areaCode
     * @return
     */
    UserRedPacketDTO enableRedPacket(BasicParam basicParam, Long userId, String areaCode);
}
