package com.bxm.localnews.user.service;

import java.util.List;

import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.vo.WithdrawFlow;

/**
 * @author zhaoyadong 2019/3/6 10:18
 * @desc
 */
public interface WithdrawService {

    /**
     * 获取用户最后一笔提现信息
     *
     * @param userId
     * @return
     */
    WithdrawFlow getUserWithdrawFlow(Long userId);

    /**
     * 获取当天用户对应提现状态的所有提现信息
     *
     * @param userId
     * @param state
     * @return
     */
    List<WithdrawFlow> getUserTodayWithdraw(Long userId, Byte state);

    /**
     * 获取用户最后一笔的提现订单信息
     *
     * @return
     */
    UserWithdrawDTO getUserRecentWithdrawInfo(Long userId);

    /**
     * 获取用户提现页面对应信息
     *
     * @param userId
     * @return
     */
    WithdrawDTO getWithdrawInfo(Long userId);
}
