package com.bxm.localnews.user.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.user.domain.DailyTaskMapper;
import com.bxm.localnews.user.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.vo.DailyTask;
import com.bxm.localnews.user.vo.NoviceTaskRecord;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * Created by mars on 2018/3/5.
 */
@Service("noviceTaskRecordService")
public class NoviceTaskRecordServiceImpl implements NoviceTaskRecordService {

    private final static Logger log = LoggerFactory.getLogger(NoviceTaskRecordServiceImpl.class);

    @Resource
    private DailyTaskMapper dailyTaskMapper;

    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;

    @Override
    public void batchAdd(long userId) {
        List<DailyTask> taskList = this.dailyTaskMapper.findSelectiveByType(DailyTask.NEWBIEW_TASK);
        if (!CollectionUtils.isEmpty(taskList)) {
            List<NoviceTaskRecord> recordList = new ArrayList<>();
            for (DailyTask task : taskList) {
                NoviceTaskRecord record = new NoviceTaskRecord();
                record.setTaskId(task.getId());
                record.setState(NoviceTaskRecord.UNFINISHED);
                record.setUserId(userId);
                recordList.add(record);
            }
            this.noviceTaskRecordMapper.batchAdd(recordList);
        }
    }

    @Override
    public boolean isTaskCompleted(Long userId, String taskName) {
        NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskName(taskName, userId);
        if (noviceTaskRecord != null) {
            if (noviceTaskRecord.getState() == 1) {
                return true;
            }

        }
        return false;
    }

}
