package com.bxm.localnews.user.service.impl;

import javax.annotation.Resource;

import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;

import org.springframework.stereotype.Service;

/**
 * Created by mars on 2018/2/28.
 */
@Service("userAuthService")
public class UserAuthServiceImpl implements UserAuthService {

    @Resource
    private UserAuthMapper userAuthMapper;

    @Override
    public int addUserAuth(Byte type, Long userId, String identifier, String credential) {
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(type);
        auth.setIdentifier(identifier);
        auth.setCredential(credential);
        int flag = this.userAuthMapper.insertSelective(auth);

        return flag;
    }

    @Override
    public UserAuth selectByUserAuth(Byte type, String openId) {
        return userAuthMapper.selectByUserAuth(type, openId);
    }

    @Override
    public UserAuth selectByUserAuth(Long userId, Byte type) {
        return userAuthMapper.selectByUserId(type, userId);
    }

    @Override
    public Message addUserAuthByWeixin(Long userId, String unionId, String openId) {
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(AppConst.LOGIN_TYPE.WEIXIN);
        auth.setIdentifier(unionId);
        this.userAuthMapper.insertSelective(auth);

        auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(AppConst.LOGIN_TYPE.WEIXIN_OPENID);
        auth.setIdentifier(openId);
        this.userAuthMapper.insertSelective(auth);
        return Message.build();
    }
}
