package com.bxm.localnews.user.service.impl;

import javax.annotation.Resource;

import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.SignIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;

import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class UserBaseInfoServiceImpl extends BaseService implements UserBaseInfoService {

    @Resource
    RedisStringAdapter redisStringAdapter;

    @Resource
    private UserMapper userBaseInfoMapper;

    @Resource
    private UserAccountService userAccountService;

    @Resource
    private VipIntegrationService vipIntegrationService;

    @Resource
    private SignIntegrationService signIntegrationService;

    @Resource
    private UserProperties userProperties;

    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;

    @Resource
    private MessageUserIntegrationService messageUserIntegrationService;

    @Override
    public UserBaseInfoDTO getUserInfoForWST(Long userId, int platform) {
        //得到用户基本信息
        if (null == userId) {
            logger.error("用户id不能为空");
            return null;
        }
        User user = this.userBaseInfoMapper.selectByUserId(userId);
        if (null != user) {
            //获取用户签到信息(已废弃)
//            SignWarper signWarper = signIntegrationService.listSignRecord(userId, platform);


            //得到用户账号取得总金币
//            UserAmount userAmount = userAmountService.findAmountByUserId(userId);
//            if (userAmount != null) {
//                userBaseInfoDTO.setGoldNum(userAmount.getJbBalance().compareTo(BigDecimal.ZERO) == 0 ? null : userAmount.getJbBalance().intValue());
//            }
            UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
//            UserAccount userAccount = userAccountService.getUserAccountDetail(userId);
//            if (userAccount != null) {
//                BigDecimal usableGold = new BigDecimal(userAccount.getUsableGold());
//                userBaseInfoDTO.setGoldNum(usableGold.compareTo(BigDecimal.ZERO) == 0 ? null :
//                        userAccount.getUsableGold().intValue());
//            }
            userBaseInfoDTO.setNickname(StringUtils.isBlank(user.getNickname()) ? StringUtils.hideMobile(user.getPhone()) : user.getNickname());
            userBaseInfoDTO.setHeadImg(StringUtils.isBlank(user.getHeadImg()) ? userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
            userBaseInfoDTO.setPhone(user.getPhone());
            userBaseInfoDTO.setForumNum(user.getPostNum() + user.getReplyNum());
            //得到用户VIP邀请人数
            int count = vipIntegrationService.countVipByUser(userId);
            userBaseInfoDTO.setInviteNum(count);
//            userBaseInfoDTO.setSignWarper(signWarper);
            userBaseInfoDTO.setMaterialFinished(checkCompleteInfo(user.getId()));

            //获取通知红点
            KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(userId);
            Boolean redPoint = redisStringAdapter.get(redPointKey, Boolean.class);
            if (redPoint == null) {
                redPoint = Boolean.FALSE;
            }
            userBaseInfoDTO.setRedPoint(redPoint);
            int msgCount = messageUserIntegrationService.countTotalMsg(userId);
            userBaseInfoDTO.setNoticeNum(msgCount);
            return userBaseInfoDTO;
        } else {
            return null;
        }
    }

    /**
     * 检查用户是否已经完善资料，如果已经完善则不显示“完善个人资料”按钮
     * 用户可以通过点击头像更改个人信息
     *
     * @param userId
     * @return
     */
    private boolean checkCompleteInfo(Long userId) {
        return noviceTaskRecordService.isTaskCompleted(userId, TaskEnum.TASK_IMPROVE_INFO.getDesc());
    }

}
