package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.vo.User;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserSyncServiceImpl implements UserSyncService {

    private UserNewsIntegrationService userNewsIntegrationService;

    @Autowired
    public UserSyncServiceImpl(UserNewsIntegrationService userNewsIntegrationService) {
        this.userNewsIntegrationService = userNewsIntegrationService;
    }

    @Async
    @Override
    public void sync(User user) {
        userNewsIntegrationService.syncUser(user);
    }
}
