package com.bxm.localnews.user.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;

import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.user.config.WithdrawConfig;
import com.bxm.localnews.user.domain.WithdrawMapper;
import com.bxm.localnews.user.dto.WithdrawConfigDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.enums.WithdrawTypeEnum;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserWithdrawService;
import com.bxm.localnews.user.service.WithdrawService;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Lists;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author zhaoyadong 2019/3/7 21:42
 * @desc
 */
@Service
public class UserWithdrawServiceImpl extends BaseService implements UserWithdrawService {

    private WithdrawConfig withdrawConfig;

    private UserAccountService userAccountService;

    private WithdrawService withdrawService;

    private WithdrawMapper withdrawMapper;

    @Autowired
    public UserWithdrawServiceImpl(WithdrawConfig withdrawConfig, UserAccountService userAccountService,
                                   WithdrawService withdrawService, WithdrawMapper withdrawMapper) {
        this.withdrawConfig = withdrawConfig;
        this.userAccountService = userAccountService;
        this.withdrawService = withdrawService;
        this.withdrawMapper = withdrawMapper;
    }

    @Override
    public BigDecimal userWithdraw(Long userId, BigDecimal amount) {
//        logger.info("用户[{}]发起提现，金额为[{}]", userId, amount);
//        Set<BigDecimal> withdrawSet = withdrawConfig.getWithdrawSet();
//        if (!withdrawSet.contains(amount)) {
//            logger.error("提现金额列表[{}]不包含金额为[{}]", JSON.toJSONString(withdrawSet), amount);
//            return BigDecimal.ZERO;
//        }
//
//        UserAccount userAccount = userAccountService.getUserAccountDetail(userId);
//        if (userAccount.getDrawablelCash().compareTo(amount) == -1) {
//            logger.error("用户[{}]的账户余额为：[{}]，小于提现金额[{}],不允许提现", userId, userAccount.getDrawablelCash(),
//                    amount);
//        }
//
//        withDraw(userId, amount);
//        //提现小于2元直接提现-----不走审核
//        BigDecimal limitAmount = new BigDecimal("2");
//        if (amount.compareTo(limitAmount) < 1) {
//
//        }
        return amount;
    }

    @Override
    public WithdrawDTO getWithDrawList(Long userId) {
        WithdrawDTO withdrawDTO = new WithdrawDTO();
        UserAccount userAccount = userAccountService.getUserAccountDetail(userId);
        withdrawDTO.setAvailableCash(userAccount.getDrawablelCash());
        WithdrawFlow withdrawFlow = withdrawService.getUserWithdrawFlow(userId);
        //最后一笔提现信息
        if (withdrawFlow != null && WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState())) {
            if ("V2_ACCOUNT_SIMPLE_BAN".equals(withdrawFlow.getRemark())) {
                withdrawDTO.setFailMsg("您的微信号未实名认证，提现失败，请实名认证后再提现");
            } else {
                withdrawDTO.setFailMsg("系统繁忙，请稍后再试。");
            }
        }
        //判断金额是否大于0
        if (BigDecimal.ZERO.compareTo(userAccount.getWithdrawalCash()) == 0) {
            withdrawDTO.setWithdrawConfigDTOList(withdrawConfig.getNotWithdrawList());
        } else {
            //提现金额满10元
            List<WithdrawConfigDTO> withdrawDTOList = Lists.newArrayList();
            withdrawConfig.getHavingWithdrawList().forEach(withdrawConfigDTO -> {
                WithdrawConfigDTO withdrawConfig = new WithdrawConfigDTO();
                BeanUtils.copyProperties(withdrawConfigDTO, withdrawConfig);
                withdrawDTOList.add(withdrawConfig);
            });
            logger.debug("当前用户[{}]已提现金额为[{}]", userId, userAccount.getWithdrawalCash());
            if (userAccount.getWithdrawalCash().compareTo(BigDecimal.TEN) != -1) {
                logger.debug("当前用户[{}]的2元提现增加限制");
                WithdrawConfigDTO withdrawConfigDTO = withdrawDTOList.get(0);
                withdrawConfigDTO.setWithdrawNumber(1);

                //判断两元是否可以提现
                if (withdrawFlow == null) {
                    withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                } else {
                    List<WithdrawFlow> withdrawFlowList = withdrawService.getUserTodayWithdraw(userId, WithdrawEnum.SUCCESS_PAYMENT.getState());
                    if (CollectionUtils.isEmpty(withdrawDTOList)) {
                        withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                    } else {
                        Optional<WithdrawFlow> successWithdrawFlow = withdrawFlowList.stream().filter(withdraw ->
                                withdraw.getAmount().compareTo(BigDecimal.valueOf(2L)) == 0
                        ).findFirst();
                        if (successWithdrawFlow.isPresent()) {
                            logger.debug("当前用户[{}]今日已提现, 设置为今日不能提现");
                            withdrawConfigDTO.setEnableWithdraw(false);
                        } else {
                            withdrawConfigDTO.setEnableWithdraw(Boolean.TRUE);
                        }
                    }
                }
            }
            withdrawDTO.setWithdrawConfigDTOList(withdrawDTOList);
        }
        return withdrawDTO;
    }

    /**
     * 判断日期是否是今天
     *
     * @param date
     * @return
     */
    private Boolean isToday(Date date) {
        return DateUtils.formatAtWill(new Date(), DateUtils.DATE_FORMAT).
                equals(DateUtils.formatAtWill(date, DateUtils.DATE_FORMAT));
    }

    /**
     * 用户提现
     *
     * @param userId
     * @param amount
     */
    private void withDraw(Long userId, BigDecimal amount) {
        WithdrawFlow withdrawFlow = new WithdrawFlow();
        Long id = nextSequence();
        withdrawFlow.setId(id);
        withdrawFlow.setOrderNo(generateWithdrawNum());
        withdrawFlow.setPayChannel(getWithdrawChannel());
        withdrawFlow.setUserId(userId);
        withdrawFlow.setState(WithdrawEnum.AUDIT.getState());
        withdrawFlow.setAmount(amount);
        Date now = new Date();
        withdrawFlow.setCreateTime(now);
        withdrawFlow.setUpdateTime(now);

        //增加提现订单
        withdrawMapper.addWithdrawFlow(withdrawFlow);
        //更新账户信息
        updateUserAccount(userId, amount, id);
    }

    /**
     * 提现更新账户信息
     *
     * @param userId
     * @param award
     * @param relationId
     */
    private void updateUserAccount(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE,
                new BigDecimal("-" + award), relationId, CashFlowTypeEnum.WECHAT_WITHDRAWAL.name(), null);
        userAccountService.addCash(accountCashParam);
    }

    /**
     * 生成订单号
     *
     * @return
     */
    private String generateWithdrawNum() {
        String prefix = WithdrawTypeEnum.getNameByType(WithdrawTypeEnum.WX_WITHDRAW.getType());
        return NidGeneratorUtil.getOrderNo(prefix);
    }

    private Long getWithdrawChannel() {
        return WithdrawTypeEnum.WX_WITHDRAW.getId();
    }
}
