package com.bxm.localnews.user.service.impl;

import java.util.List;

import com.bxm.localnews.user.domain.WithdrawMapper;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.service.WithdrawService;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/6 10:18
 * @desc
 */
@Service
public class WithdrawServiceImpl extends BaseService implements WithdrawService {

    @Autowired
    private WithdrawMapper withdrawMapper;

    @Override
    public WithdrawFlow getUserWithdrawFlow(Long userId) {
        return withdrawMapper.getUserLastWithdraw(userId);
    }

    @Override
    public List<WithdrawFlow> getUserTodayWithdraw(Long userId, Byte state) {
        return withdrawMapper.getUserTodayWithdraw(userId, state);
    }

    @Override
    public UserWithdrawDTO getUserRecentWithdrawInfo(Long userId) {

        return covertUserWithdraw(getUserWithdrawFlow(userId));
    }

    @Override
    public WithdrawDTO getWithdrawInfo(Long userId) {
        return null;
    }

    /**
     * 转换用户提现信息
     *
     * @param withdrawFlow
     * @return
     */
    private UserWithdrawDTO covertUserWithdraw(WithdrawFlow withdrawFlow) {
        if (withdrawFlow == null) {
            return null;
        }

        UserWithdrawDTO userWithdrawDTO = new UserWithdrawDTO();

        userWithdrawDTO.setUserId(withdrawFlow.getUserId());
        userWithdrawDTO.setAmount(withdrawFlow.getAmount());
        userWithdrawDTO.setWithdrawNum(withdrawFlow.getOrderNo());
        userWithdrawDTO.setStatus(withdrawFlow.getState());
        return userWithdrawDTO;
    }
}
