/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.DailyTaskMapper;
import com.bxm.localnews.user.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.vo.DailyTask;
import com.bxm.localnews.user.vo.NoviceTaskRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="noviceTaskRecordService")
public class NoviceTaskRecordServiceImpl
implements NoviceTaskRecordService {
    private static final Logger log = LoggerFactory.getLogger(NoviceTaskRecordServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;

    @Override
    public void batchAdd(long userId) {
        List taskList = this.dailyTaskMapper.findSelectiveByType(DailyTask.NEWBIEW_TASK);
        if (!CollectionUtils.isEmpty((Collection)taskList)) {
            ArrayList<NoviceTaskRecord> recordList = new ArrayList<NoviceTaskRecord>();
            for (DailyTask task : taskList) {
                NoviceTaskRecord record = new NoviceTaskRecord();
                record.setTaskId(task.getId());
                record.setState(Byte.valueOf((byte)0));
                record.setUserId(Long.valueOf(userId));
                recordList.add(record);
            }
            this.noviceTaskRecordMapper.batchAdd(recordList);
        }
    }

    @Override
    public boolean isTaskCompleted(Long userId, String taskName) {
        NoviceTaskRecord noviceTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskName(taskName, userId);
        return noviceTaskRecord != null && noviceTaskRecord.getState() == 1;
    }
}

