/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.UserEventIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.service.CashFlowService;
import com.bxm.localnews.user.service.GoldFlowService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.WithdrawService;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
extends BaseService
implements UserAccountService {
    private UserAccountMapper userAccountMapper;
    private CashFlowService cashFlowService;
    private WithdrawService withdrawService;
    @Autowired
    private UserService userService;
    @Autowired
    private InviteRecordService inviteRecordService;
    @Autowired
    private UserEventIntegrationService userEventIntegrationService;
    @Autowired
    private GoldFlowService goldFlowService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Autowired
    private MessageUserIntegrationService messageUserIntegrationService;

    @Autowired
    public UserAccountServiceImpl(UserAccountMapper userAccountMapper, CashFlowService cashFlowService, WithdrawService withdrawService) {
        this.userAccountMapper = userAccountMapper;
        this.cashFlowService = cashFlowService;
        this.withdrawService = withdrawService;
    }

    @Override
    public BigDecimal getUserTotalCash(Long userId) {
        return this.getUserAccountDetail(userId).getTotalCash();
    }

    @Override
    public UserAccount getUserAccountDetail(Long userId) {
        this.logger.debug("\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        return this.getAndSetUserAccount(userId);
    }

    @Override
    public Message createUserAccount(Long userId) {
        this.logger.debug("\u521b\u5efa\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        this.getAndSetUserAccount(userId);
        return Message.build();
    }

    @Override
    public UserAccountDTO getUserAccount(Long userId) {
        this.logger.debug("\u8f6c\u6362\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u4eceuserAccount \u8f6c\u4e3auserAccountDTO;\u7528\u6237id:[{}]", (Object)userId);
        UserAccountDTO userAccountDTO = this.convertUserAccount(this.getAndSetUserAccount(userId));
        if (!this.redisStringAdapter.hasKey(this.getUserWithdrawPop(userId)).booleanValue()) {
            if (BigDecimal.ZERO.compareTo(userAccountDTO.getDrawablelCash().add(userAccountDTO.getNotArriveCash())) < 1) {
                this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
            }
            userAccountDTO.setEnablePopWithdraw(Boolean.valueOf(true));
        }
        return userAccountDTO;
    }

    @Override
    public UserAccountDayCashDTO getUserAccountAndDetail(Long userId) {
        UserWithdrawDTO userWithdrawDTO = this.withdrawService.getUserRecentWithdrawInfo(userId);
        if (userWithdrawDTO == null || WithdrawEnum.SUCCESS_PAYMENT.getState().equals(userWithdrawDTO.getStatus()) || WithdrawEnum.FAIL_PAYMENT.getState().equals(userWithdrawDTO.getStatus())) {
            userWithdrawDTO = null;
        }
        return new UserAccountDayCashDTO(this.getUserAccount(userId), this.cashFlowService.getRecentSevenDayCashFlowByUser(userId), userWithdrawDTO);
    }

    @Override
    public UserCashGoldDTO getUserCashGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u5728\u4e2a\u4eba\u4e2d\u5fc3\u7684\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        UserAccount userAccount = this.getAndSetUserAccount(userId);
        BigDecimal cash = userAccount.getDrawablelCash().add(userAccount.getTempCash()).add(userAccount.getStabilizeCash());
        return new UserCashGoldDTO(cash, userAccount.getUsableGold());
    }

    @Override
    public Boolean addCash(AccountCashParam param) {
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getAddTotal() || null == param.getCash() || new BigDecimal(0).compareTo(param.getCash()) == 0) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u989d\u66f4\u65b0\uff1a{}", (Object)param);
        int isAdded = 0;
        if (CashEnum.TEMP_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserTempCash(param.getUserId(), param.getCash());
        } else if (CashEnum.STABILIZE_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserStabilizeCash(param.getUserId(), param.getCash());
        } else if (CashEnum.DRAWABLEL_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserDrawableCash(param.getUserId(), param.getCash());
        }
        if (isAdded > 0) {
            if (param.getAddTotal().booleanValue()) {
                this.userAccountMapper.addUserTotalCash(param.getUserId(), param.getCash());
                this.addUserEvent(param.getUserId(), param.getCash());
                if (!CashFlowTypeEnum.RED_PACKET.name().equals(param.getCashFlowType())) {
                    this.pushChangeAccountMsg(param.getUserId(), param.getCash());
                }
            }
            CashFlow cashFlow = new CashFlow();
            cashFlow.setId(this.nextSequence());
            cashFlow.setUserId(param.getUserId());
            cashFlow.setAmount(param.getCash());
            cashFlow.setRelationId(param.getRelationId());
            cashFlow.setType(param.getCashFlowType());
            cashFlow.setConvertType(param.getConvertType());
            cashFlow.setCreateTime(new Date());
            this.cashFlowService.addCashFlow(cashFlow);
            return true;
        }
        return false;
    }

    @Override
    public Boolean transferCash(AccountCashParam param) {
        this.logger.debug("\u8f6c\u6362\u7684\u8d26\u6237\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)param));
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getCash() || null == param.getConvertType() || param.getCash().compareTo(new BigDecimal(0)) <= 0) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u989d\u8f6c\u5316\uff1a{}", (Object)param);
        int isTransferred = 0;
        if (CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.tempToStabilize(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.STABILIZE_TO_DRAWABLE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.stabilizeToDrawable(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.DRAWABLE_TO_WITHDRAWAL.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.drawableToWithdrawal(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.tempToDrawable(param.getUserId(), param.getCash());
        }
        if (isTransferred > 0) {
            CashFlow cashFlow = new CashFlow();
            cashFlow.setId(this.nextSequence());
            cashFlow.setUserId(param.getUserId());
            cashFlow.setAmount(param.getCash());
            cashFlow.setRelationId(param.getRelationId());
            cashFlow.setType(param.getCashFlowType());
            cashFlow.setConvertType(param.getConvertType());
            cashFlow.setCreateTime(new Date());
            this.cashFlowService.addCashFlow(cashFlow);
            return true;
        }
        return false;
    }

    @Override
    public Message updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte state) {
        if (WithdrawEnum.SUCCESS_PAYMENT.getState().equals(state)) {
            this.updateUserCash(userId, amount);
            this.updateInviteUserCash(userId);
        }
        if (WithdrawEnum.FAIL_PAYMENT.getState().equals(state)) {
            AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, amount, null, CashFlowTypeEnum.FAIL_WITHDRAWAL.name(), null);
            this.addCash(accountCashParam);
        }
        return Message.build();
    }

    @Override
    public BigDecimal getUserDrawablelCash(Long userId) {
        return this.getUserAccount(userId).getDrawablelCash();
    }

    @Override
    public Boolean addGold(AccountGoldParam param) {
        this.logger.debug("\u7528\u6237\u8d26\u6237\u66f4\u65b0\u91d1\u5e01\u7684\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param || null == param.getUserId() || null == param.getGoldType() || null == param.getAddTotal() || null == param.getGold() || new BigDecimal(0).equals(param.getGold())) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u5e01\u66f4\u65b0\uff1a{}", (Object)param);
        Integer gold = param.getGold();
        if (GoldEnum.TEMP_GOLD.name().equals(param.getGoldType())) {
            this.userAccountMapper.addUserTempGold(param.getUserId(), gold);
        } else if (GoldEnum.USABLE_GOLD.name().equals(param.getGoldType())) {
            this.userAccountMapper.addUserUsableGold(param.getUserId(), gold);
        } else if (GoldEnum.CONSUME_GOLD.name().equals(param.getGoldType())) {
            this.userAccountMapper.addUserConsumeGold(param.getUserId(), gold);
            gold = Math.negateExact(gold);
        }
        if (param.getAddTotal().booleanValue()) {
            this.userAccountMapper.addUserTotalGold(param.getUserId(), gold);
        }
        GoldFlow goldFlow = new GoldFlow(this.nextSequence(), param.getUserId(), gold, param.getGoldFlowType(), param.getRelationId());
        this.goldFlowService.addGoldFlow(goldFlow);
        this.addMsg(goldFlow);
        return true;
    }

    @Override
    public Integer getUserUsableGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237[{}]\u7684\u8d26\u6237\u91d1\u5e01\u53ef\u7528\u4f59\u989d", (Object)userId);
        return this.getUserAccountDetail(userId).getUsableGold();
    }

    @Override
    public void userWithdrawPop(Long userId) {
        this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
    }

    private UserAccount generateUserAccount(Long userId) {
        UserAccount userAccount = new UserAccount(userId);
        userAccount.setId(this.nextSequence());
        return userAccount;
    }

    private UserAccountDTO convertUserAccount(UserAccount userAccount) {
        UserAccountDTO userAccountDTO = new UserAccountDTO();
        userAccountDTO.setId(userAccount.getId());
        userAccountDTO.setUserId(userAccount.getUserId());
        userAccountDTO.setDrawablelCash(userAccount.getDrawablelCash());
        userAccountDTO.setNotArriveCash(userAccount.getTempCash().add(userAccount.getStabilizeCash()));
        userAccountDTO.setTotalCash(userAccount.getTotalCash());
        return userAccountDTO;
    }

    private UserAccount getAndSetUserAccount(Long userId) {
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (userAccount == null) {
            this.logger.error("\u7528\u6237[{}]\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)userId);
            userAccount = this.generateUserAccount(userId);
            this.userAccountMapper.addUserAccount(userAccount);
        } else {
            BigDecimal usableGold = BigDecimal.valueOf(userAccount.getUsableGold().intValue());
            if (usableGold != null && usableGold.compareTo(new BigDecimal(0)) < 0) {
                userAccount.setUsableGold(Integer.valueOf(0));
            }
        }
        return userAccount;
    }

    private void addUserEvent(Long userId, BigDecimal amount) {
        UserCashGoldDTO userCashGoldDTO = this.getUserCashGold(userId);
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.USER_ACCOUNT_ENVET).addExtend("userId", (Object)userId).addExtend("current", (Object)userCashGoldDTO.getCash()).addExtend("val", (Object)amount);
        this.userEventIntegrationService.addUserEvent(pushPayloadInfo);
    }

    private void pushChangeAccountMsg(Long userId, BigDecimal amount) {
        String title = "\ud83d\udcb0\u65b0\u589e\u8d4f\u91d1" + amount.setScale(2, 4) + "\u5143\uff0c\u70b9\u51fb\u67e5\u770b >";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.ADD_CASH);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        this.pushMsgIntegrationService.pushMsg(message);
    }

    private void addMsg(GoldFlow goldFlow) {
        String title = "";
        Integer type = 1;
        if (goldFlow.getAmount() > 0) {
            title = "\u8d26\u6237\u4f59\u989d\u589e\u52a0" + goldFlow.getAmount() + "\u91d1\u5e01\uff0c\u76ee\u524d\u5171\u6709" + this.getUserUsableGold(goldFlow.getUserId()) + "\u91d1\u5e01\u5566\uff01";
        } else {
            title = "\u91d1\u5e01\u8d26\u6237\u6263\u9664" + Math.abs(goldFlow.getAmount()) + "\u91d1\u5e01\uff0c\u76ee\u524d\u5269\u4f59" + this.getUserUsableGold(goldFlow.getUserId()) + "\u91d1\u5e01";
            type = 2;
        }
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.UPDATE_GOLD);
        info.setMsgId(Long.valueOf(this.nextId()));
        info.addExtend("type", (Object)type);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)goldFlow.getUserId()));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        this.messageUserIntegrationService.addMessage(message, goldFlow.getUserId());
    }

    private void updateInviteUserCash(Long userId) {
        this.logger.info("------------- \u66f4\u65b0\u9080\u8bf7\u4eba\u7684\u6c38\u4e45\u8d4f\u91d1\u4e3a\u53ef\u63d0\u73b0\u91d1\u989d ----------------");
        User user = this.userService.selectByPrimaryKey(userId);
        if (user.getInviteUserId() == null) {
            this.logger.info("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)userId);
            return;
        }
        this.logger.info("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u4e3a\u7a7a\uff0c\u9080\u8bf7\u4ebaid\uff1a[{}]", (Object)userId, (Object)user.getInviteUserId());
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId);
        if (inviteRecord == null) {
            this.logger.warn("\u7528\u6237[{}]\u4e0e\u9080\u8bf7\u4eba[{}]\u7684\u5173\u7cfb\u65e0\u6548", (Object)userId, (Object)user.getInviteUserId());
        }
        if (!InviteRecordStateEnum.LOGIN_APP.getName().equals(inviteRecord.getInviteState())) {
            this.logger.info("\u5f53\u524d\u9080\u8bf7\u5173\u7cfb\u4e0d\u662f\u5904\u4e8e\u8fd8\u672a\u6210\u529f\u63d0\u73b0\u72b6\u6001----\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c");
            return;
        }
        this.logger.info("\u9080\u8bf7\u4eba[{}]\u589e\u52a0\u53ef\u63d0\u73b0\u8d4f\u91d1[{}]", (Object)user.getInviteUserId(), (Object)inviteRecord.getAward());
        inviteRecord.setInviteState(InviteRecordStateEnum.SUCCESS_WITHDRAW.getName());
        inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
        this.updateInviteRecord(inviteRecord);
        AccountCashParam accountCashParam = new AccountCashParam(inviteRecord.getUserId(), CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.STABILIZE_TO_DRAWABLE.name());
        this.transferCash(accountCashParam);
    }

    private void updateInviteRecord(InviteRecord inviteRecord) {
        this.inviteRecordService.updateInviteRecord(inviteRecord);
    }

    private void updateUserCash(Long userId, BigDecimal amount) {
        this.userAccountMapper.addUserWithdrawalCash(userId, amount);
    }

    private KeyGenerator getUserWithdrawPop(Long userId) {
        return RedisConfig.USER_WITHDRAW_POP.copy().appendKey((Object)userId);
    }
}

