/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.SignIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserBaseInfoServiceImpl
extends BaseService
implements UserBaseInfoService {
    @Resource
    RedisStringAdapter redisStringAdapter;
    @Resource
    private UserMapper userBaseInfoMapper;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private SignIntegrationService signIntegrationService;
    @Resource
    private UserProperties userProperties;
    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;
    @Resource
    private MessageUserIntegrationService messageUserIntegrationService;

    @Override
    public UserBaseInfoDTO getUserInfoForWST(Long userId, int platform) {
        if (null == userId) {
            this.logger.error("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        User user = this.userBaseInfoMapper.selectByUserId(userId.longValue());
        if (null != user) {
            UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
            userBaseInfoDTO.setNickname(StringUtils.isBlank((CharSequence)user.getNickname()) ? StringUtils.hideMobile((String)user.getPhone()) : user.getNickname());
            userBaseInfoDTO.setHeadImg(StringUtils.isBlank((CharSequence)user.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
            userBaseInfoDTO.setPhone(user.getPhone());
            userBaseInfoDTO.setForumNum(Integer.valueOf(user.getPostNum() + user.getReplyNum()));
            int count = this.vipIntegrationService.countVipByUser(userId);
            userBaseInfoDTO.setInviteNum(Integer.valueOf(count));
            userBaseInfoDTO.setMaterialFinished(this.checkCompleteInfo(user.getId()));
            KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey((Object)userId);
            Boolean redPoint = (Boolean)this.redisStringAdapter.get(redPointKey, Boolean.class);
            if (redPoint == null) {
                redPoint = Boolean.FALSE;
            }
            userBaseInfoDTO.setRedPoint(redPoint.booleanValue());
            int msgCount = this.messageUserIntegrationService.countTotalMsg(userId);
            userBaseInfoDTO.setNoticeNum(Integer.valueOf(msgCount));
            return userBaseInfoDTO;
        }
        return null;
    }

    private boolean checkCompleteInfo(Long userId) {
        return this.noviceTaskRecordService.isTaskCompleted(userId, TaskEnum.TASK_IMPROVE_INFO.getDesc());
    }
}

