/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.config.BizConfigProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.ChannelMapper;
import com.bxm.localnews.user.dto.ChannelDTO;
import com.bxm.localnews.user.service.ChannelService;
import com.bxm.localnews.user.vo.Channel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@RefreshScope
public class ChannelServiceImpl
implements ChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ChannelServiceImpl.class);
    private ChannelMapper channelMapper;
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public ChannelServiceImpl(ChannelMapper channelMapper, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.channelMapper = channelMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public List<ChannelDTO> listChannel(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage((int)current, (int)pageSize);
        List list = this.channelMapper.selectChannelList(searchMap);
        String channelUrl = this.bizConfigProperties.getChannelUrl();
        for (ChannelDTO channelDTO : list) {
            channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode());
        }
        return list;
    }

    @Override
    public Channel getChannelByCode(String code) {
        Channel channel = new Channel();
        List<Channel> channelList = this.getChannelList();
        for (Channel ch : channelList) {
            if (!ch.getCode().equals(code)) continue;
            channel = ch;
            break;
        }
        return channel;
    }

    @Override
    public String getChannelCodeById(Long channelId) {
        Channel channel = new Channel();
        List<Channel> channelList = this.getChannelList();
        for (Channel ch : channelList) {
            if (!ch.getId().equals(channelId)) continue;
            channel = ch;
            break;
        }
        return channel.getCode();
    }

    private List<Channel> getChannelList() {
        TypeReference<List<Channel>> typeReference = new TypeReference<List<Channel>>(){};
        List channelList = (List)this.redisStringAdapter.get(this.getChannelListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)channelList)) {
            channelList = this.channelMapper.getAllChannel();
            this.redisStringAdapter.set(this.getChannelListKey(), (Object)channelList);
        }
        return channelList;
    }

    private KeyGenerator getChannelListKey() {
        return RedisConfig.BASE_CHANNEL.copy().appendKey((Object)"list");
    }
}

