/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.config.CommonProperties;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserRedPacketDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.RedPacketService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserEquipmentService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class RedPacketServiceImpl
extends BaseService
implements RedPacketService {
    private UserService userService;
    private UserAccountService userAccountService;
    private LocationIntegrationService locationIntegrationService;
    private InviteRecordService inviteRecordService;
    private CommonProperties commonProperties;
    private DistributedLock distributedLock;
    private UserLocationHistoryMapper userLocationHistoryMapper;
    private UserEquipmentService userEquipmentService;
    private UserProperties userProperties;

    @Autowired
    public RedPacketServiceImpl(UserService userService, UserAccountService userAccountService, LocationIntegrationService locationIntegrationService, InviteRecordService inviteRecordService, CommonProperties commonProperties, DistributedLock distributedLock, UserLocationHistoryMapper userLocationHistoryMapper, UserEquipmentService userEquipmentService, UserProperties userProperties) {
        this.userService = userService;
        this.userAccountService = userAccountService;
        this.locationIntegrationService = locationIntegrationService;
        this.inviteRecordService = inviteRecordService;
        this.commonProperties = commonProperties;
        this.distributedLock = distributedLock;
        this.userLocationHistoryMapper = userLocationHistoryMapper;
        this.userEquipmentService = userEquipmentService;
        this.userProperties = userProperties;
    }

    @Override
    public Json<BigDecimal> userReceiveRedPacket(Long userId, BasicParam basicParam, String areaCode) {
        LocationDTO locationDTO = this.getLocationByAreaCode(areaCode);
        if (!this.userIsReceiveRedPacket(userId, locationDTO, basicParam.getDevcId()).booleanValue()) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.logger.info("\u7528\u6237[{}]\u5728\u5730\u533a[{}]\u9886\u53d6\u7ea2\u5305\u91d1\u989d\u4e3a\uff1a[{}]", new Object[]{userId, areaCode, locationDTO.getNewRedPacket()});
        String requestId = this.nextSequence().toString();
        if (this.distributedLock.lock(userId.toString(), requestId)) {
            User user = this.userService.selectByPrimaryKey(userId);
            if (user.getInviteUserId() != null) {
                this.logger.info("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u4e3a\u7a7a\uff0c\u9080\u8bf7\u4ebaid\uff1a[{}]", (Object)userId, (Object)user.getInviteUserId());
                InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId);
                if (inviteRecord != null) {
                    BigDecimal award = locationDTO.getPromoteBounty();
                    this.logger.info("\u9080\u8bf7\u4eba[{}]\u589e\u52a0\u6c38\u4e45\u8d4f\u91d1[{}]", (Object)user.getInviteUserId(), (Object)award);
                    BigDecimal totalAward = inviteRecord.getAward().add(award);
                    if (InviteTypeEnum.OFFLINE.getName().equals(user.getRegisterChannel()) && this.checkIsAssociation(user.getInviteUserId()).booleanValue()) {
                        this.logger.info("\u5f53\u524d\u9080\u8bf7\u4eba[{}]\u662f\u534f\u4f1a\u4eba\u5458, \u4fee\u6539\u83b7\u53d6\u7684\u8d4f\u91d1\u4e3a\uff1a[{}]", (Object)userId, (Object)this.userProperties.getBountyOffline());
                        totalAward = inviteRecord.getAward().add(this.userProperties.getBountyOffline());
                        award = this.userProperties.getBountyOffline();
                    }
                    inviteRecord.setAward(totalAward);
                    inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
                    inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
                    this.inviteRecordService.updateInviteRecord(inviteRecord);
                    this.addUserAccountByPromote(inviteRecord, award, user);
                }
            }
        } else {
            return ResultUtil.genFailedResult((String)"\u4f60\u5df2\u9886\u53d6\u8fc7\u65b0\u4eba\u7ea2\u5305");
        }
        this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u589e\u52a0\u7ea2\u5305\u91d1\u989d[{}]", (Object)userId, (Object)locationDTO.getNewRedPacket());
        this.addUserAccountByRedPacket(userId, locationDTO.getNewRedPacket(), null);
        this.userService.updateUserReceiveRedPacket(userId);
        this.addReceiveEquipment(basicParam.getDevcId());
        this.distributedLock.unlock(userId.toString(), requestId);
        return ResultUtil.genSuccessResult((Object)locationDTO.getNewRedPacket());
    }

    private void addReceiveEquipment(String equipment) {
        UserEquipment userEquipment = new UserEquipment(Long.valueOf(this.nextId()), equipment, "DRAW");
        this.userEquipmentService.addUserEquipment(userEquipment);
    }

    private void addUserAccountByRedPacket(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.TRUE, award, relationId, CashFlowTypeEnum.RED_PACKET.name(), null);
        this.userAccountService.addCash(accountCashParam);
    }

    private void addUserAccountByPromote(InviteRecord inviteRecord, BigDecimal award, User user) {
        AccountCashParam accountCashParam = new AccountCashParam(inviteRecord.getUserId(), CashEnum.STABILIZE_CASH.name(), Boolean.TRUE, award, inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), null);
        accountCashParam.setInviteType(inviteRecord.getType());
        accountCashParam.setInvitedUserName(user.getNickname());
        this.userAccountService.addCash(accountCashParam);
    }

    @Override
    public UserRedPacketDTO enableRedPacket(String devcId, Long userId, String areaCode) {
        InviteRecord inviteRecord;
        UserRedPacketDTO userRedPacketDTO = new UserRedPacketDTO();
        LocationDTO locationDTO = this.getLocationByAreaCode(areaCode);
        if (!this.userIsReceiveRedPacket(userId, locationDTO, devcId).booleanValue()) {
            return userRedPacketDTO;
        }
        userRedPacketDTO.setEnableRedPacket(this.byteToBoolean(locationDTO.getEnablePaidPromote()));
        userRedPacketDTO.setAmount(locationDTO.getNewRedPacket());
        userRedPacketDTO.setInviteUserHeadImg(this.commonProperties.getAppIconUrl());
        userRedPacketDTO.setInviteUserNickname(this.commonProperties.getAppName());
        userRedPacketDTO.setLinkUrl(this.commonProperties.getLinkUrl());
        User user = this.userService.selectByPrimaryKey(userId);
        if (user != null && user.getInviteUserId() != null && (inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId)) != null) {
            UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(user.getInviteUserId());
            userRedPacketDTO.setInviteUserNickname(userInfoDTO.getNickname());
            userRedPacketDTO.setInviteUserHeadImg(userInfoDTO.getHeadImg());
        }
        return userRedPacketDTO;
    }

    private Boolean userIsReceiveRedPacket(Long userId, LocationDTO locationDTO, String equipment) {
        LocationDTO userLocation;
        this.logger.info("-----------  \u8fdb\u5165\u7528\u6237\u662f\u5426\u53ef\u4ee5\u9886\u53d6\u7ea2\u5305\u7684\u5224\u65ad  -----------------");
        this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u7684\u8bbe\u5907\u53f7[{}]\uff0c\u5b9e\u65f6\u5b9a\u4f4d\u4fe1\u606f\uff1a[{}]", new Object[]{userId, equipment, JSON.toJSONString((Object)locationDTO)});
        if (locationDTO == null || !this.byteToBoolean(locationDTO.getEnablePaidPromote()).booleanValue()) {
            this.logger.info("\u5f53\u524d\u5730\u533a[{}]\u672a\u5f00\u901a\u63a8\u5e7f\u8d5a\u94b1", (Object)(null == locationDTO ? "" : locationDTO.getName()));
            return Boolean.FALSE;
        }
        UserLocationHistory userLocationHistory = this.userLocationHistoryMapper.getLastLocationByUser(userId);
        if (!(userLocationHistory == null || (userLocation = this.getLocationByAreaCode(userLocationHistory.getLocationCode())) != null && this.byteToBoolean(userLocation.getEnablePaidPromote()).booleanValue())) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u9009\u62e9\u7684\u5730\u533a[{}]\u672a\u5f00\u901a\u63a8\u5e7f\u8d5a\u94b1", (Object)(null == userLocation ? "" : userLocation.getName()));
            return Boolean.FALSE;
        }
        if (this.userEquipmentService.checkExistEquipment(equipment, "DRAW").booleanValue()) {
            this.logger.info("\u5f53\u524d\u8bbe\u5907[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)equipment);
            return Boolean.FALSE;
        }
        User user = this.userService.selectByPrimaryKey(userId);
        if (user == null) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u4e0d\u5b58\u5728", (Object)userId);
            return Boolean.FALSE;
        }
        if (!this.byteToBoolean(user.getReceiveRedPacket()).booleanValue()) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)userId);
            return Boolean.FALSE;
        }
        this.logger.info("-----------  \u5f53\u524d\u7528\u6237[{}]\u53ef\u4ee5\u9886\u53d6\u7ea2\u5305  -----------------", (Object)userId);
        return Boolean.TRUE;
    }

    private LocationDTO getLocationByAreaCode(String areaCode) {
        return this.locationIntegrationService.getLocationByGeocode(areaCode);
    }

    private Boolean checkIsAssociation(Long userId) {
        return this.inviteRecordService.checkIsAssociation(userId);
    }

    private Boolean byteToBoolean(byte byteNumber) {
        return byteNumber == 1 ? Boolean.TRUE : Boolean.FALSE;
    }
}

