/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.UserEventIntegrationService;
import com.bxm.localnews.user.integration.WithdrawIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.service.CashFlowService;
import com.bxm.localnews.user.service.GoldFlowService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.UserWithdrawService;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
extends BaseService
implements UserAccountService {
    @Resource
    private UserAccountMapper userAccountMapper;
    @Resource
    private CashFlowService cashFlowService;
    @Resource
    private UserWithdrawService userWithdrawService;
    @Resource
    private UserService userService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private UserEventIntegrationService userEventIntegrationService;
    @Resource
    private GoldFlowService goldFlowService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private MessageUserIntegrationService messageUserIntegrationService;
    @Resource
    private UserProperties userProperties;
    @Resource
    private WithdrawIntegrationService withdrawIntegrationService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public BigDecimal getUserTotalCash(Long userId) {
        return this.getUserAccountDetail(userId).getTotalCash();
    }

    @Override
    public UserAccount getUserAccountDetail(Long userId) {
        this.logger.debug("\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        return this.getAndSetUserAccount(userId);
    }

    @Override
    public Message createUserAccount(Long userId) {
        this.logger.debug("\u521b\u5efa\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        this.getAndSetUserAccount(userId);
        return Message.build();
    }

    @Override
    public UserAccountDTO getUserAccount(Long userId) {
        this.logger.debug("\u8f6c\u6362\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u4eceuserAccount \u8f6c\u4e3auserAccountDTO;\u7528\u6237id:[{}]", (Object)userId);
        UserAccountDTO userAccountDTO = this.convertUserAccount(this.getAndSetUserAccount(userId));
        if (!this.redisStringAdapter.hasKey(this.getUserWithdrawPop(userId)).booleanValue()) {
            if (BigDecimal.ZERO.compareTo(userAccountDTO.getDrawablelCash().add(userAccountDTO.getNotArriveCash())) < 1) {
                this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
            }
            userAccountDTO.setEnablePopWithdraw(Boolean.valueOf(true));
        }
        return userAccountDTO;
    }

    @Override
    public UserAccountDTO getUserAccountAndEnableWithdraw(Long userId) {
        this.logger.debug("\u8f6c\u6362\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff1a\u4eceuserAccount \u8f6c\u4e3auserAccountDTO;\u7528\u6237id:[{}]", (Object)userId);
        UserAccountDTO userAccountDTO = this.convertUserAccount(this.getAndSetUserAccount(userId));
        if (this.cashFlowService.enableWithdraw(userId)) {
            this.logger.info("\u7528\u6237\u5728app\u5916\u6210\u529f\u9886\u53d6\u65b0\u7528\u6237\u8d4f\u91d1,\u53ef\u63d0\u73b0\u72b6\u6001\u6539\u4e3atrue,\u7528\u6237id\u4e3a:{}", (Object)userId);
            userAccountDTO.setEnablePopWithdraw(Boolean.valueOf(true));
        }
        if (!this.redisStringAdapter.hasKey(this.getUserWithdrawPop(userId)).booleanValue()) {
            if (BigDecimal.ZERO.compareTo(userAccountDTO.getDrawablelCash().add(userAccountDTO.getNotArriveCash())) < 0) {
                this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
                userAccountDTO.setEnablePopWithdraw(Boolean.valueOf(true));
            }
        } else {
            userAccountDTO.setEnablePopWithdraw(Boolean.valueOf(false));
        }
        return userAccountDTO;
    }

    @Override
    public UserAccountDayCashDTO getUserAccountAndDetail(Long userId) {
        UserWithdrawDTO userWithdrawDTO = this.userWithdrawService.getUserRecentWithdrawInfo(userId);
        if (userWithdrawDTO == null || WithdrawEnum.SUCCESS_PAYMENT.getState().equals(userWithdrawDTO.getStatus()) || WithdrawEnum.FAIL_PAYMENT.getState().equals(userWithdrawDTO.getStatus())) {
            userWithdrawDTO = null;
        }
        return new UserAccountDayCashDTO(this.getUserAccount(userId), this.cashFlowService.getRecentSevenDayCashFlowByUser(userId), userWithdrawDTO);
    }

    @Override
    public UserCashGoldDTO getUserCashGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u5728\u4e2a\u4eba\u4e2d\u5fc3\u7684\u4fe1\u606f\uff1a\u7528\u6237id:[{}]", (Object)userId);
        UserAccount userAccount = this.getAndSetUserAccount(userId);
        BigDecimal cash = userAccount.getDrawablelCash().add(userAccount.getTempCash()).add(userAccount.getStabilizeCash());
        return new UserCashGoldDTO(cash, userAccount.getUsableGold(), BigDecimal.valueOf(userAccount.getUsableGold().intValue()).divide(this.userProperties.getGoldRate(), 2, 1), userAccount.getTotalGold());
    }

    @Override
    public Boolean addCash(AccountCashParam param) {
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getAddTotal() || null == param.getCash() || param.getCash().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u989d\u66f4\u65b0\uff1a{}", (Object)param);
        int isAdded = 0;
        if (CashEnum.TEMP_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserTempCash(param.getUserId(), param.getCash());
        } else if (CashEnum.STABILIZE_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserStabilizeCash(param.getUserId(), param.getCash());
        } else if (CashEnum.DRAWABLEL_CASH.name().equals(param.getCashType())) {
            isAdded = this.userAccountMapper.addUserDrawableCash(param.getUserId(), param.getCash());
        }
        if (isAdded > 0) {
            if (param.getAddTotal().booleanValue()) {
                this.userAccountMapper.addUserTotalCash(param.getUserId(), param.getCash());
                this.addUserEvent(param.getUserId(), param.getCash());
                if (!CashFlowTypeEnum.RED_PACKET.name().equals(param.getCashFlowType()) && !CashFlowTypeEnum.COMMAND_RED_PACKET.name().equals(param.getCashFlowType())) {
                    this.pushMsgIntegrationService.pushChangeAccountMsg(param);
                }
            }
            CashFlow cashFlow = new CashFlow();
            cashFlow.setId(this.nextSequence());
            cashFlow.setUserId(param.getUserId());
            cashFlow.setAmount(param.getCash());
            cashFlow.setRelationId(param.getRelationId());
            cashFlow.setType(param.getCashFlowType());
            cashFlow.setConvertType(param.getConvertType());
            cashFlow.setCreateTime(new Date());
            this.cashFlowService.addCashFlow(cashFlow);
            return true;
        }
        return false;
    }

    @Override
    public Boolean transferCash(AccountCashParam param) {
        this.logger.debug("\u8f6c\u6362\u7684\u8d26\u6237\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)param));
        if (null == param || null == param.getUserId() || null == param.getCashType() || null == param.getCash() || null == param.getConvertType() || param.getCash().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u989d\u8f6c\u5316\uff1a{}", (Object)param);
        int isTransferred = 0;
        if (CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.tempToStabilize(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.STABILIZE_TO_DRAWABLE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.stabilizeToDrawable(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.DRAWABLE_TO_WITHDRAWAL.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.drawableToWithdrawal(param.getUserId(), param.getCash());
        } else if (CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name().equals(param.getConvertType())) {
            isTransferred = this.userAccountMapper.tempToDrawable(param.getUserId(), param.getCash());
        }
        if (isTransferred > 0) {
            CashFlow cashFlow = new CashFlow();
            cashFlow.setId(this.nextSequence());
            cashFlow.setUserId(param.getUserId());
            cashFlow.setAmount(param.getCash());
            cashFlow.setRelationId(param.getRelationId());
            cashFlow.setType(param.getCashFlowType());
            cashFlow.setConvertType(param.getConvertType());
            cashFlow.setCreateTime(new Date());
            this.cashFlowService.addCashFlow(cashFlow);
            return true;
        }
        return false;
    }

    @Override
    public Message updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte state) {
        if (WithdrawEnum.SUCCESS_PAYMENT.getState().equals(state)) {
            this.userAccountMapper.addUserWithdrawalCash(userId, amount);
            this.updateInviteUserCash(userId, ExtraInviteStateEnum.WITHDRAW);
        }
        if (WithdrawEnum.FAIL_PAYMENT.getState().equals(state)) {
            AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, amount, null, CashFlowTypeEnum.FAIL_WITHDRAWAL.name(), null);
            this.addCash(accountCashParam);
        }
        return Message.build();
    }

    @Override
    public BigDecimal getUserDrawableCash(Long userId) {
        return this.getUserAccount(userId).getDrawablelCash();
    }

    @Override
    public Boolean addGold(AccountGoldParam param) {
        this.logger.debug("\u7528\u6237\u8d26\u6237\u66f4\u65b0\u91d1\u5e01\u7684\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param || null == param.getUserId() || null == param.getGoldType() || null == param.getAddTotal() || null == param.getGold() || 0 == param.getGold()) {
            return false;
        }
        int isAdd = 0;
        this.logger.debug("\u7528\u6237\u8d26\u6237\u91d1\u5e01\u66f4\u65b0\uff1a{}", (Object)param);
        Integer gold = param.getGold();
        if (GoldEnum.TEMP_GOLD.name().equals(param.getGoldType())) {
            isAdd = this.userAccountMapper.addUserTempGold(param.getUserId(), gold);
        } else if (GoldEnum.USABLE_GOLD.name().equals(param.getGoldType())) {
            UserAccount userAccount = this.userAccountMapper.getUserAccount(param.getUserId());
            isAdd = this.userAccountMapper.addUserUsableGold(param.getUserId(), gold);
            if (gold < 0 && userAccount.getUsableGold() + gold < 0) {
                gold = -userAccount.getUsableGold().intValue();
            }
        } else if (GoldEnum.CONSUME_GOLD.name().equals(param.getGoldType())) {
            isAdd = this.userAccountMapper.addUserConsumeGold(param.getUserId(), gold);
            gold = Math.negateExact(gold);
        }
        if (isAdd > 0) {
            boolean flag;
            if (param.getAddTotal().booleanValue()) {
                this.userAccountMapper.addUserTotalGold(param.getUserId(), gold);
            }
            GoldFlow goldFlow = new GoldFlow(this.nextSequence(), param.getUserId(), gold, param.getGoldFlowType(), param.getRelationId(), param.getContent());
            if (StringUtils.isNotBlank((CharSequence)param.getReason())) {
                goldFlow.setReason(param.getReason());
            }
            this.goldFlowService.addGoldFlow(goldFlow);
            boolean bl = flag = StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.ARTICLE_LIKE_ADD.getName(), (CharSequence)param.getGoldFlowType()) || StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.ARTICLE_LIKE_EXPEND.getName(), (CharSequence)param.getGoldFlowType()) || StringUtils.equalsIgnoreCase((CharSequence)GoldFlowTypeEnum.TASK_NEWS_SHARE.getName(), (CharSequence)param.getGoldFlowType());
            if (!flag) {
                this.messageUserIntegrationService.addGoldMsg(goldFlow, this.getUserUsableGold(param.getUserId()));
            }
            return true;
        }
        return false;
    }

    @Override
    public Integer getUserUsableGold(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237[{}]\u7684\u8d26\u6237\u91d1\u5e01\u53ef\u7528\u4f59\u989d", (Object)userId);
        return this.getUserAccountDetail(userId).getUsableGold();
    }

    @Override
    public void userWithdrawPop(Long userId) {
        this.redisStringAdapter.set(this.getUserWithdrawPop(userId), 1L);
    }

    @Override
    public Json<BigDecimal> userGoldWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
        if (this.userProperties.getMixWithdrawBalance().compareTo(amount) > 0 || amount.compareTo(this.userProperties.getMaxWithdrawBalance()) > 0) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u63d0\u73b0\u91d1\u989d[{}], \u4e0d\u6ee1\u8db3\u63d0\u73b0\u8303\u56f4", (Object)userId, (Object)amount);
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u63d0\u73b0\u91d1\u989d");
        }
        Integer usableGold = this.getUserUsableGold(userId);
        Integer transferGold = amount.multiply(this.userProperties.getGoldRate()).intValue();
        if (usableGold < transferGold) {
            this.logger.info("\u5f53\u524d\u7528\u6237[{}]\u53ef\u7528\u79ef\u5206[{}]\uff0c\u5c0f\u4e8e\u63d0\u73b0\u79ef\u5206[{}], \u4e0d\u5141\u8bb8\u63d0\u73b0", new Object[]{userId, usableGold, transferGold});
            return ResultUtil.genFailedResult((String)"\u4f59\u989d\u4e0d\u8db3");
        }
        BigDecimal withdrawAmount = this.userWithdrawService.getMiniAppUserWithdraw(userId, openId, WithdrawEnum.SUCCESS_PAYMENT.getState());
        if (this.userProperties.getTodayLimitBalance().compareTo(withdrawAmount) <= 0) {
            this.logger.info("\u7528\u6237[{}]\u4eca\u65e5\u63d0\u73b0\u91d1\u989d\u5df2\u8fbe\u4e0a\u9650", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u5355\u65e5\u5151\u6362\u5df2\u8fbe\u9650\u989d");
        }
        AccountGoldParam param = new AccountGoldParam(userId, "CONSUME_GOLD", Boolean.valueOf(false), transferGold, null, GoldFlowTypeEnum.MINI_APP_WITHDRAW.name());
        if (this.addGold(param).booleanValue()) {
            Message message = this.withdrawIntegrationService.appletWithdraw(userId, openId, amount, devcId, ip);
            if (message.isSuccess()) {
                CashFlow cashFlow = new CashFlow();
                cashFlow.setId(this.nextSequence());
                cashFlow.setUserId(userId);
                cashFlow.setAmount(amount);
                cashFlow.setType(CashFlowTypeEnum.WECHAT_WITHDRAWAL.getName());
                cashFlow.setCreateTime(new Date());
                this.cashFlowService.addCashFlow(cashFlow);
                return ResultUtil.genSuccessResult((Object)amount);
            }
            this.logger.info("\u7528\u6237[{}]\u63d0\u73b0\u5931\u8d25-----\u91d1\u5e01\u9000\u56de", (Object)userId);
            param = new AccountGoldParam(userId, "CONSUME_GOLD", Boolean.valueOf(false), Integer.valueOf(-transferGold.intValue()), null, GoldFlowTypeEnum.WITHDRAW_FAIL_RETURN.name(), null);
            this.addGold(param);
            return ResultUtil.genFailedResult((String)message.getLashMessaage());
        }
        return ResultUtil.genFailedResult((String)"\u79ef\u5206\u6263\u9664\u5931\u8d25");
    }

    @Override
    public UserCashInfoVo getUserCashInfo(Long userId) {
        User user;
        UserCashInfoVo userCashInfoVo = new UserCashInfoVo();
        userCashInfoVo.setUserId(userId);
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (null == userInfoDTO) {
            return userCashInfoVo;
        }
        userCashInfoVo.setNickname(userInfoDTO.getNickname());
        userCashInfoVo.setHeadImg(userInfoDTO.getHeadImg());
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null != userAccount) {
            userCashInfoVo.setCash(userAccount.getTotalCash());
        }
        if (null == (user = this.userService.selectByPrimaryKey(userId)) || user.getInviteUserId() == null) {
            return userCashInfoVo;
        }
        userCashInfoVo.setInviteUserId(user.getInviteUserId());
        UserInfoDTO inviteUserInfoDTO = this.userService.getUserFromRedisDB(user.getInviteUserId());
        if (null == inviteUserInfoDTO) {
            return userCashInfoVo;
        }
        userCashInfoVo.setInviteUserNickname(inviteUserInfoDTO.getNickname());
        userCashInfoVo.setInviteUserHeadImg(inviteUserInfoDTO.getHeadImg());
        UserAccount inviteUserAccount = this.userAccountMapper.getUserAccount(user.getInviteUserId());
        if (null != inviteUserAccount) {
            userCashInfoVo.setInviteUserCash(inviteUserAccount.getTotalCash());
        }
        return userCashInfoVo;
    }

    private UserAccount generateUserAccount(Long userId) {
        UserAccount userAccount = new UserAccount(userId);
        userAccount.setId(this.nextSequence());
        return userAccount;
    }

    private UserAccountDTO convertUserAccount(UserAccount userAccount) {
        UserAccountDTO userAccountDTO = new UserAccountDTO();
        userAccountDTO.setId(userAccount.getId());
        userAccountDTO.setUserId(userAccount.getUserId());
        userAccountDTO.setDrawablelCash(userAccount.getDrawablelCash());
        userAccountDTO.setNotArriveCash(userAccount.getTempCash().add(userAccount.getStabilizeCash()));
        userAccountDTO.setTotalCash(userAccount.getTotalCash());
        return userAccountDTO;
    }

    private UserAccount getAndSetUserAccount(Long userId) {
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null == userAccount) {
            this.logger.warn("\u7528\u6237[{}]\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)userId);
            userAccount = this.generateUserAccount(userId);
            this.userAccountMapper.addUserAccount(userAccount);
        } else {
            BigDecimal usableGold = BigDecimal.valueOf(userAccount.getUsableGold().intValue());
            if (usableGold != null && usableGold.compareTo(BigDecimal.ZERO) < 0) {
                userAccount.setUsableGold(Integer.valueOf(0));
            }
        }
        return userAccount;
    }

    private void addUserEvent(Long userId, BigDecimal amount) {
        UserCashGoldDTO userCashGoldDTO = this.getUserCashGold(userId);
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.USER_ACCOUNT_ENVET).addExtend("userId", (Object)userId).addExtend("current", (Object)userCashGoldDTO.getCash()).addExtend("val", (Object)amount);
        this.userEventIntegrationService.addUserEvent(pushPayloadInfo);
    }

    @Override
    public void updateInviteUserCash(Long userId, ExtraInviteStateEnum currentStateEnum) {
        User user = this.userService.selectByPrimaryKey(userId);
        if (null == user.getInviteUserId()) {
            this.logger.debug("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)userId);
            return;
        }
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId);
        if (null == inviteRecord) {
            this.logger.debug("\u7528\u6237[{}]\u4e0e\u9080\u8bf7\u4eba[{}]\u7684\u5173\u7cfb\u65e0\u6548", (Object)userId, (Object)user.getInviteUserId());
            return;
        }
        if (!InviteRecordStateEnum.LOGIN_APP.getName().equals(inviteRecord.getInviteState())) {
            this.logger.debug("\u5f53\u524d\u9080\u8bf7\u5173\u7cfb\u4e0d\u662f\u5904\u4e8e\u767b\u5f55app\u72b6\u6001----\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c");
            return;
        }
        Boolean changeInviteUserCashState = false;
        if (InviteTypeEnum.FACEINVITE.getName().equals(inviteRecord.getType())) {
            Integer inviteState = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), userId.toString(), Integer.class);
            if (null != inviteState) {
                if (ExtraInviteStateEnum.WITHDRAW.equals((Object)currentStateEnum) && ExtraInviteStateEnum.LOGIN_TWICE.getStatus().equals(inviteState) || ExtraInviteStateEnum.LOGIN_TWICE.equals((Object)currentStateEnum) && ExtraInviteStateEnum.WITHDRAW.getStatus().equals(inviteState)) {
                    changeInviteUserCashState = true;
                    this.redisHashMapAdapter.remove(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), new String[]{userId.toString()});
                }
            } else {
                this.redisHashMapAdapter.put(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), userId.toString(), (Object)currentStateEnum.getStatus());
            }
        } else {
            changeInviteUserCashState = true;
        }
        if (changeInviteUserCashState.booleanValue()) {
            this.logger.info("\u9080\u8bf7\u4eba[{}]\u589e\u52a0\u53ef\u63d0\u73b0\u8d4f\u91d1[{}]", (Object)user.getInviteUserId(), (Object)inviteRecord.getAward());
            inviteRecord.setInviteState(InviteRecordStateEnum.SUCCESS_WITHDRAW.getName());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            this.inviteRecordService.updateInviteRecord(inviteRecord);
            AccountCashParam accountCashParam = new AccountCashParam(inviteRecord.getUserId(), CashEnum.DRAWABLEL_CASH.name(), Boolean.FALSE, inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.STABILIZE_TO_DRAWABLE.name());
            this.transferCash(accountCashParam);
        }
    }

    private KeyGenerator getUserWithdrawPop(Long userId) {
        return RedisConfig.USER_WITHDRAW_POP.copy().appendKey((Object)userId);
    }
}

