/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.HobbyMapper;
import com.bxm.localnews.user.domain.UserHobbyMapper;
import com.bxm.localnews.user.service.UserHobbyService;
import com.bxm.localnews.user.vo.Hobby;
import com.bxm.localnews.user.vo.UserHobby;
import com.bxm.newidea.component.service.BaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

@Service(value="userHobbyService")
public class UserHobbyServiceImpl
extends BaseService
implements UserHobbyService {
    @Resource
    private UserHobbyMapper userHobbyMapper;
    @Resource
    private HobbyMapper hobbyMapper;

    @Override
    public List<Hobby> listHobby() {
        return this.hobbyMapper.selectByModel(new Hobby());
    }

    @Override
    public List<UserHobby> listUserHobby(Long userId) {
        UserHobby userHobbyParam = new UserHobby();
        userHobbyParam.setUserId(userId);
        List hobbyList = this.hobbyMapper.selectByModel(new Hobby());
        List userHobbyList = this.userHobbyMapper.selectByModel(userHobbyParam);
        List<UserHobby> userHobbyConvertList = hobbyList.stream().map(this::convertUserHobby).collect(Collectors.toList());
        ArrayList<UserHobby> resultHobbyList = new ArrayList<UserHobby>();
        userHobbyConvertList.forEach(hobby -> {
            if (userHobbyList.stream().anyMatch(userHobby -> userHobby.getName().equals(hobby.getName()))) {
                hobby.setIsDefault(Byte.valueOf((byte)1));
            }
            resultHobbyList.add((UserHobby)hobby);
        });
        return resultHobbyList;
    }

    private UserHobby convertUserHobby(Hobby hobby) {
        UserHobby userHobby = new UserHobby();
        userHobby.setName(hobby.getName());
        userHobby.setIsDefault(Byte.valueOf((byte)0));
        userHobby.setSortNo(hobby.getSortNo());
        return userHobby;
    }

    @Override
    public void saveUserHobby(Long userId, String[] names) {
        this.userHobbyMapper.deleteByUserId(userId);
        if (ArrayUtils.isNotEmpty((Object[])names)) {
            ArrayList<UserHobby> userHobbyList = new ArrayList<UserHobby>();
            for (int i = 0; i < names.length; ++i) {
                UserHobby userHobby = new UserHobby();
                userHobby.setUserId(userId);
                userHobby.setName(names[i]);
                userHobby.setSortNo(Integer.valueOf(i));
                userHobby.setId(this.nextSequence());
                userHobbyList.add(userHobby);
            }
            this.userHobbyMapper.batchInsert(userHobbyList);
        }
    }
}

