/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.config.BizConfigProperties;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.enums.LevelEunm;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.AdvertIntegrationService;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MissionIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.RecommendIntegrationService;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.PushParam;
import com.bxm.localnews.user.param.RecordWechatParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.service.ChannelService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.PushInfo;
import com.bxm.localnews.user.vo.RegSourceCounter;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="userService")
@RefreshScope
public class UserServiceImpl
extends BaseService
implements UserService,
UserInternalService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final long MAX_HEAD_IMAGE_SIZE = 0x500000L;
    private static final int AREA_CODE_LENGTH = 12;
    @Resource
    private RecommendIntegrationService recommendIntegrationService;
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserLocationHistoryMapper userLocationHistoryMapper;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private AliyunOSSService aliyunOSSService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private ChannelService channelService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private UserLoginHistoryService userLoginHistoryService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private UserSyncService userSyncService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private AdvertIntegrationService advertIntegrationService;

    @Override
    public UserInfoDTO getUserFromRedisDB(long userId) {
        UserInfoDTO dto = this.getUserFromRedis(userId);
        if (null == dto || StringUtils.isEmpty((CharSequence)dto.getNickname()) || StringUtils.isEmpty((CharSequence)dto.getHeadImg())) {
            this.logger.debug("\u7528\u6237[{}]\u4eceredis\u83b7\u53d6\u5230\u7684\u5934\u50cf\u6216\u8005\u6635\u79f0\u4e3a\u7a7a\uff0c\u91cd\u65b0\u52a0\u8f7d\u7528\u6237\u5728\u6570\u636e\u5e93\u7684\u6570\u636e", (Object)userId);
            dto = this.loadUserToRedis(userId);
        }
        this.logger.debug("\u83b7\u53d6\u7528\u6237[{}]\u8be6\u7ec6\u4fe1\u606f[{}]", (Object)userId, (Object)JSON.toJSONString((Object)dto));
        return dto;
    }

    private UserInfoDTO getUserFromRedis(long userId) {
        this.logger.debug("\u4eceredis\u83b7\u53d6\u7528\u6237[{}]\u6570\u636e", (Object)userId);
        String userStr = (String)this.redisHashMapAdapter.get(RedisConfig.USER_INFO, userId + "", String.class);
        return (UserInfoDTO)JSON.parseObject((String)userStr, UserInfoDTO.class);
    }

    private UserInfoDTO loadUserToRedis(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (user != null) {
            UserInfoDTO dto = this.convertUserToDTO(user);
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }
        return null;
    }

    @Override
    public boolean checkUserExistByPhone(String phone, Integer flag) {
        User user = this.userMapper.findByPhone(phone);
        if (null == user) {
            return false;
        }
        UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
        if (flag == 1) {
            return userAuth != null;
        }
        return true;
    }

    @Override
    public UserInfoDTO convertUserToDTO(User user) {
        UserInfoDTO dto = new UserInfoDTO();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getNickname())) {
            dto.setNickname(StringUtils.hideMobile((String)user.getPhone()));
        }
        if (StringUtils.isBlank((CharSequence)dto.getHeadImg())) {
            dto.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        return dto;
    }

    @Override
    public String getToken() {
        long currentTime = System.currentTimeMillis();
        return MD5Util.hgmd5((String)(currentTime + this.userProperties.getAppKey() + RandomUtils.nextInt((int)0, (int)10000)));
    }

    @Override
    public Long getExpireTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 30);
        return calendar.getTime().getTime();
    }

    @Override
    public Json<UserInfoDTO> refreshToken(Long userId, String refreshToken) {
        User user = this.userMapper.getUserByRefreshToken(userId.longValue(), refreshToken);
        if (null == user) {
            return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)"\u767b\u5f55\u5931\u6548");
        }
        user.setExpiretime(this.getExpireTime());
        user.setToken(this.getToken());
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO dto = this.convertUserToDTO(user);
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)dto);
    }

    @Override
    public Json<LoginMeta> register(LoginInfo loginInfo, BasicParam basicParam, String firstOpenType) {
        if (StringUtils.isEmpty((CharSequence)loginInfo.getEquipment())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u53c2\u6570");
        }
        User user = this.userMapper.findByEquipment(loginInfo.getEquipment());
        if (null == user) {
            user = this.addUser(loginInfo, basicParam.getPlatform(), basicParam.getChnl(), (byte)0);
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9759\u9ed8\u6ce8\u518c\u751f\u6210\u9ed8\u8ba4\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}]", (Object)loginInfo);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
            this.userLoginHistoryService.save(user, loginInfo);
        }
        UserInfoDTO dto = this.convertUserToDTO(user);
        this.logger.debug("\u628a\u7528\u6237[{}]\u6570\u636e[{}]\u5b58\u5165redis", (Object)user.getId(), (Object)JSON.toJSONString((Object)dto));
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId().toString(), (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)new LoginMeta(dto));
    }

    @Override
    public Json<User> doH5Register(LoginInfo loginInfo, Integer platform, String chnl) {
        if (!this.checkH5RegisterParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (!this.checkSmsCode(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        String messageByCheckAuth = this.checkBindExist(loginInfo);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckAuth)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth);
        }
        User user = this.userMapper.findByPhone(loginInfo.getLoginName());
        if (null != user) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        user = this.addUser(loginInfo, platform, chnl, (byte)1);
        if (user.getId() > 0L) {
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237H5\u6ce8\u518c\uff0cloginInfo:[{}]", (Object)loginInfo);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
            return ResultUtil.genSuccessResult((Object)user);
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u6ce8\u518c\u5931\u8d25");
    }

    private boolean checkSmsCode(LoginInfo loginInfo) {
        if (!this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)3), loginInfo.getLoginName(), loginInfo.getCode()).booleanValue()) {
            this.logger.debug("checkVcode failed,loginInfo[{}]", (Object)loginInfo);
            return false;
        }
        return true;
    }

    private boolean checkH5RegisterParam(LoginInfo loginInfo) {
        return StringUtils.isNotBlank((CharSequence)loginInfo.getLoginName()) && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && 1 == loginInfo.getType();
    }

    @Override
    public User addUser(LoginInfo loginInfo, Integer platform, String chnl, Byte userType) {
        log.info("\u6dfb\u52a0\u65b0\u7528\u6237\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        User user = this.saveUser(loginInfo, platform, chnl, userType);
        if (0 != userType) {
            this.userAuthService.saveAuth(user.getId(), loginInfo);
            this.noviceTaskRecordService.batchAdd(user.getId());
            this.userAccountService.createUserAccount(user.getId());
            this.missionIntegrationService.completeTask(user.getId(), TaskEnum.TASK_FIRST_LOGIN, String.valueOf(user.getId()));
            this.saveRegSourceInfo(loginInfo, user, chnl);
            this.triggerAndroidId(loginInfo, platform);
            this.bizLogIntegrationService.newUser(user.getId(), chnl, loginInfo.getLoginName(), BigDecimal.ZERO, StringUtils.isNotEmpty((CharSequence)user.getRegisterChannel()) ? user.getRegisterChannel() : "0", null, platform);
        }
        log.debug("\u6dfb\u52a0\u7528\u6237\u6210\u529f\uff1a[{}]", (Object)JSON.toJSONString((Object)user));
        return user;
    }

    private void triggerAndroidId(LoginInfo loginInfo, Integer platform) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u5b89\u5353\u8d26\u53f7\uff0c\u89e6\u53d1\u5e7f\u544a\u56de\u8c03\uff0cloginInfo:{}\uff0cplatform:{}", (Object)JSON.toJSONString((Object)loginInfo), (Object)platform);
        }
        if (1 == platform) {
            this.advertIntegrationService.triggerAdvert(loginInfo.getEquipment());
        }
    }

    private User saveUser(LoginInfo loginInfo, Integer platform, String chnl, Byte userType) {
        User originalUser;
        Date date = new Date();
        User user = new User();
        user.setToken(this.getToken());
        user.setRefreshtoken(this.getToken());
        user.setRegisterClient(null == platform ? "0" : String.valueOf(platform));
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)0));
        user.setPhone(loginInfo.getPhone());
        user.setEquipment(loginInfo.getEquipment());
        user.setRegisteredAddress(loginInfo.getRegisteredaddress());
        user.setPhoneModel(loginInfo.getPhonemodel());
        user.setState(userType);
        user.setLevel(LevelEunm.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setExpiretime(this.getExpireTime());
        user.setLastLoginTime(date);
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        if (null != loginInfo.getRegIp()) {
            user.setRegIp(loginInfo.getRegIp());
        }
        if (null != loginInfo.getLastLoginIp()) {
            user.setLastLoginIp(loginInfo.getLastLoginIp());
        }
        user.setLocationCode(this.bizConfigProperties.getLocationCode());
        user.setLocationName(this.bizConfigProperties.getLocationName());
        if (null != loginInfo.getId() && null != (originalUser = this.userMapper.selectByPrimaryKey(loginInfo.getId())) && null != originalUser.getLocationCode() && null != originalUser.getLocationName()) {
            user.setLocationCode(originalUser.getLocationCode());
            user.setLocationName(originalUser.getLocationName());
        }
        user.setChannelId(this.getChannelId(chnl));
        this.userMapper.insertSelective(user);
        if (0 != userType) {
            User loginUser = new User();
            loginUser.setId(user.getId());
            this.setLoginName(loginUser, loginInfo);
            this.userMapper.updateByPrimaryKeySelective(loginUser);
        }
        return user;
    }

    private void saveRegSourceInfo(LoginInfo loginInfo, User user, String chnl) {
        Long inviteCode = loginInfo.getInviteCode();
        if (null == inviteCode) {
            return;
        }
        this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9080\u8bf7\u8bb0\u5f55,loginInfo:[{}],user:[{}],chnl:[{}]", new Object[]{loginInfo, user, chnl});
        this.saveRegSourceCount(loginInfo, user, chnl);
        this.bizLogIntegrationService.inviteSuccessed(inviteCode, user.getId(), null == user.getRegisterClient() ? null : Integer.valueOf(user.getRegisterClient()));
        this.missionIntegrationService.completeTask(inviteCode, TaskEnum.TASK_INVITED_FRIEND, user.getId().toString());
    }

    private void statisticsGold(Long inviteCode) {
        KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(inviteCode + ":" + DateUtils.formatDate((Date)new Date()));
        this.redisStringAdapter.incrementWithDefault(userRewardSumKey, AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM.longValue(), AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM.intValue());
        this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
    }

    private void generatorInvitationReward(Long userId, Long inviteCode) {
        PayFlow payFlow = PayFlow.initPayFlow((Long)inviteCode, (Byte)TaskEnum.TASK_INVITED_FRIEND.getType(), (Byte)10, (String)userId.toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM, false);
    }

    private void saveRegSourceCount(LoginInfo loginInfo, User user, String chnl) {
        RegSourceCounter counter = new RegSourceCounter();
        counter.setId(this.nextSequence().toString());
        counter.setRegTime(new Date());
        counter.setUserId(user.getId());
        counter.setChannel(this.getChannelId(chnl));
        counter.setInviteUserId(loginInfo.getInviteCode());
    }

    private Long getChannelId(String chnl) {
        return this.channelService.getChannelByCode(chnl).getId();
    }

    private void setLoginName(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            user.setHeadImg(user.getHeadImg() == null ? this.getImageFromUrl(loginInfo.getHeadImg(), user.getId()) : user.getHeadImg());
        } else {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
    }

    private String getImageFromUrl(String headImg, Long userId) {
        try {
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                this.logger.debug("\u6839\u636eurl\u83b7\u5f97\u56fe\u7247\u7684\u6d41\u72b6\u6001\uff1a{}", (Object)inputStream.available());
            }
            int hashCode = (int)(userId % 10L);
            String path = "avatar/" + hashCode + "/" + userId + ".jpeg";
            return this.aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return headImg;
        }
    }

    @Override
    public Json<UserInfoDTO> binding(LoginInfo loginInfo, Long userId) {
        if (!this.bindingCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (1 == loginInfo.getType() && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)2), loginInfo.getLoginName(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        String messageByCheckAuth = this.checkBindExist(loginInfo);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckAuth)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth);
        }
        User user = this.userMapper.selectByPrimaryKey(userId);
        String messageByCheckUser = this.checkBindRepeat(loginInfo.getType(), user);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckUser)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser);
        }
        this.setLoginName(user, loginInfo);
        this.userMapper.updateByPrimaryKeySelective(user);
        this.userAuthService.addUserAuth(loginInfo.getType(), user.getId(), loginInfo.getLoginName(), null);
        UserInfoDTO dto = this.convertUserToDTO(user);
        this.checkCompleteInfo(dto);
        this.logger.debug("\u628a\u7528\u6237[{}]\u6570\u636e[{}]\u5b58\u5165redis", (Object)userId, (Object)JSON.toJSONString((Object)dto));
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId() + "", (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)dto);
    }

    private String checkBindExist(LoginInfo loginInfo) {
        UserAuth auth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        String message = "";
        if (null != auth) {
            if (1 == loginInfo.getType()) {
                message = "\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            } else if (3 == loginInfo.getType()) {
                message = "\u5fae\u4fe1\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            } else if (4 == loginInfo.getType()) {
                message = "\u5fae\u535a\u5df2\u88ab\u7ed1\u5b9a";
            } else if (2 == loginInfo.getType()) {
                message = "QQ\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            }
        }
        return message;
    }

    private String checkBindRepeat(Byte loginInfoType, User user) {
        String message = "";
        if (1 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getPhone())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u624b\u673a\u53f7";
        } else if (3 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getWeixin())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u53f7";
        } else if (4 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getWeibo())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u5fae\u535a\u8d26\u53f7";
        } else if (2 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getQq())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9aQQ\u8d26\u53f7";
        }
        return message;
    }

    @Override
    public Message updateUserInfo(UserParam updateUser, Long userId, MultipartFile file) {
        int i;
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            this.logger.error("\u7528\u6237\u66f4\u65b0\u8d44\u6599\u65f6\u672a\u5f97\u5230\u7528\u6237:[{}]", (Object)JSONObject.toJSONString((Object)updateUser));
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        if (1 != user.getState()) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5c1a\u672a\u767b\u5f55");
        }
        if (null != updateUser.getNickname()) {
            if (null == user.getIsTempNickName() || user.getIsTempNickName() == 1) {
                user.setNickname(updateUser.getNickname());
                user.setIsTempNickName(Byte.valueOf((byte)0));
            } else {
                return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u4fee\u6539\u6635\u79f0\u5df2\u8fbe\u4e0a\u9650");
            }
        }
        if (null != updateUser.getPhone()) {
            if (!Validater.checkPhone((String)updateUser.getPhone())) {
                return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u683c\u5f0f\u6709\u8bef");
            }
            if (!updateUser.getPhone().equals(user.getPhone()) && this.checkUserExistByPhone(updateUser.getPhone(), 0)) {
                return Message.build((boolean)false, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
            }
            user.setPhone(updateUser.getPhone());
        }
        if (null != updateUser.getSex()) {
            user.setSex(updateUser.getSex());
            this.bizLogIntegrationService.changeGender(user.getId(), (int)updateUser.getSex().byteValue(), null);
        }
        if (null != updateUser.getAddress()) {
            user.setAddress(updateUser.getAddress());
        }
        if (null != updateUser.getBirthday()) {
            user.setBirthday(updateUser.getBirthday());
        }
        if (null != file) {
            if (file.getSize() > 0x500000L) {
                return Message.build((boolean)false, (String)"\u5934\u50cf\u56fe\u7247\u8fc7\u5927,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            String headImg = this.upLoadHeadImage(userId, file);
            if (null != headImg) {
                user.setHeadImg(this.upLoadHeadImage(userId, file));
                user.setIsTempHeadImg(Byte.valueOf((byte)0));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)updateUser.getHeadImg())) {
            user.setHeadImg(updateUser.getHeadImg());
        }
        if ((i = this.userMapper.updateByPrimaryKeySelective(user)) > 0) {
            UserInfoDTO dto = this.convertUserToDTO(user);
            log.info("\u7528\u6237\u66f4\u65b0\u540e\u7684\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)user));
            this.userSyncService.sync(user);
            this.checkCompleteInfo(dto);
            this.logger.debug("\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599:[{}]", (Object)JSON.toJSONString((Object)dto));
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
            return Message.build((boolean)true).addParam("user", (Object)dto);
        }
        return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public void checkCompleteInfo(UserInfoDTO user) {
        if (null != user.getWeixin() && null != user.getBirthday() && StringUtils.isNotEmpty((CharSequence)user.getHeadImg()) && StringUtils.isNotEmpty((CharSequence)user.getNickname()) && StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
            this.logger.debug("\u7528\u6237\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)user));
            this.missionIntegrationService.completeTask(user.getId(), TaskEnum.TASK_IMPROVE_INFO, null);
        }
    }

    @Override
    public LocationUserInfoDTO getLocationUserInfo(Long userId) {
        return this.userMapper.getLocationUserInfo(userId);
    }

    @Override
    public String getDefaultHeadImgUrl() {
        return this.userProperties.getDefaultHeadImgUrl();
    }

    @Override
    public User selectByPrimaryKey(Long userId) {
        return this.userMapper.selectByPrimaryKey(userId);
    }

    @Override
    public Boolean checkUnionIdIsUser(String unionId) {
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), unionId);
        if (userAuth == null) {
            return false;
        }
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        if (user != null && user.getState() == 2) {
            return false;
        }
        return true;
    }

    @Override
    public User selectUserByUnionId(String unionId) {
        return this.userMapper.findByWeixin(unionId);
    }

    @Override
    public User selectUserByEquipment(String equipment) {
        return this.userMapper.findByEquipment(equipment);
    }

    @Override
    public Long checkExistEquipment(String equipment) {
        return this.userMapper.checkExistEquipment(equipment);
    }

    @Override
    public Boolean updateUserReceiveRedPacket(Long userId) {
        this.userMapper.updateUserReceiveRedPacket(userId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean isRiskUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return user.getRisk() == 1;
    }

    @Override
    public Boolean addPostReplyNum(Long userId, Integer type) {
        if (1 == type) {
            this.userMapper.addPostNum(userId);
        } else if (2 == type) {
            this.userMapper.minusPostNum(userId);
        } else if (3 == type) {
            this.userMapper.addReplyNum(userId);
        } else if (4 == type) {
            this.userMapper.minusReplyNum(userId);
        }
        return true;
    }

    @Override
    public Long addWSTAppletUser() {
        User user = this.saveWSTUser();
        return user.getId();
    }

    private User saveWSTUser() {
        User user = new User();
        Date date = new Date();
        user.setToken(this.getToken());
        user.setRefreshtoken(this.getToken());
        user.setRegisterClient("5");
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)0));
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEunm.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setExpiretime(this.getExpireTime());
        user.setLastLoginTime(date);
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setLocationCode(this.bizConfigProperties.getLocationCode());
        user.setLocationName(this.bizConfigProperties.getLocationName());
        this.userMapper.insertSelective(user);
        return user;
    }

    @Override
    public Boolean isTempUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return 2 == user.getState();
    }

    @Override
    public Message createUser(TempUserParam userParam) {
        Message message = Message.build();
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId())) {
            return message;
        }
        this.logger.debug("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)userParam));
        User user = new User();
        user = this.convertUser(userParam, user);
        Long userId = null;
        Boolean isInsertInviteRecord = false;
        UserAuth unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        if (null == unionUserAuth || null == unionUserAuth.getUserId()) {
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.userMapper.insertSelective(user);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
                isInsertInviteRecord = true;
            }
        } else {
            userId = unionUserAuth.getUserId();
            User existedUser = this.userMapper.selectByUserId(userId.longValue());
            isInsertInviteRecord = this.updateUserInvite(user, existedUser);
        }
        if (null != userParam.getOpenId()) {
            if (InviteTypeEnum.APPLETDRAW.getName().equals(userParam.getInviteType())) {
                UserAuth appletUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)7), userParam.getOpenId());
                if (null == appletUserAuth || null == appletUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)7, userId, userParam.getOpenId(), null);
                }
            } else {
                UserAuth weixinUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)5), userParam.getOpenId());
                if (null == weixinUserAuth || null == weixinUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)5, userId, userParam.getOpenId(), null);
                }
            }
        }
        this.addInviteRecord(userParam, userId, isInsertInviteRecord);
        return message.addParam("userId", (Object)userId);
    }

    @Override
    public Message updateUser(TempUserParam userParam) {
        Message message = Message.build();
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId())) {
            return message;
        }
        UserAuth openUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)8), userParam.getOpenId());
        if (null == openUserAuth) {
            this.logger.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8fdb\u884c\u9759\u9ed8\u767b\u9646\uff0c\u7981\u6b62\u521b\u5efa\u7528\u6237");
            return message;
        }
        this.logger.debug("\u5f00\u59cb\u66f4\u65b0\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u3011\u4e34\u65f6\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)userParam));
        User user = this.userMapper.selectByUserId(openUserAuth.getUserId().longValue());
        Long userId = null;
        boolean isInsertInviteRecord = false;
        UserAuth unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        if (null == unionUserAuth || null == unionUserAuth.getUserId()) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u672a\u8fdb\u5165APP--------\u76f4\u63a5\u7ed1\u5b9a\u7528\u6237, unionId: " + userParam.getUnionId());
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                user = this.convertUser(userParam, user);
                user.setState(Byte.valueOf((byte)1));
                this.userMapper.updateByPrimaryKeySelective(user);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
                if (userParam.getInviteUserId() != null && userParam.getTaskInvited().booleanValue()) {
                    this.addInviteGoldAndPushMsg(userParam, 0);
                }
                this.missionIntegrationService.completeTask(userId, TaskEnum.TASK_FIRST_LOGIN, String.valueOf(userId));
                isInsertInviteRecord = true;
            }
        } else {
            userId = unionUserAuth.getUserId();
            this.updateUserAuth(openUserAuth, userId);
            User existedUser = this.userMapper.selectByUserId(userId.longValue());
            isInsertInviteRecord = this.updateUserInvite(user, existedUser);
            if (userParam.getInviteUserId() != null && existedUser != null) {
                this.addInviteGoldAndPushMsg(userParam, 1);
            }
        }
        this.logger.debug("\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u79fb\u9664\u7528\u6237[{}]\u5728redis\u7684\u7f13\u5b58", (Object)userId);
        this.redisHashMapAdapter.remove(RedisConfig.USER_INFO, new String[]{userId + ""});
        this.addInviteRecord(userParam, userId, isInsertInviteRecord);
        return message.addParam("userId", (Object)userId);
    }

    private void addInviteGoldAndPushMsg(TempUserParam userParam, Integer userType) {
        Integer userGold;
        if (0 == userType) {
            userGold = this.userProperties.getNewUserGold();
        } else if (1 == userType) {
            userGold = this.userProperties.getOldUserGold();
        } else {
            return;
        }
        this.userAccountService.addGold(new AccountGoldParam(userParam.getInviteUserId(), "USABLE_GOLD", Boolean.valueOf(true), userGold, null, GoldFlowTypeEnum.TASK_INVITE_FRIEND.name()));
        this.pushMsgIntegrationService.pushInviteMsg(userParam.getInviteUserId(), userParam.getHeadImg(), userParam.getNickName(), userGold, userType);
    }

    private void updateUserAuth(UserAuth openUserAuth, Long userId) {
        if (!userId.equals(openUserAuth.getUserId())) {
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), userId);
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), openUserAuth.getUserId());
            openUserAuth.setId(Long.valueOf(this.nextId()));
            openUserAuth.setUserId(userId);
            this.userAuthMapper.insertSelective(openUserAuth);
        }
    }

    private void addInviteRecord(TempUserParam userParam, Long userId, Boolean isInsertInviteRecord) {
        if (isInsertInviteRecord.booleanValue() && userParam.getInviteUserId() != null && !userParam.getInviteUserId().equals(userId)) {
            this.inviteRecordService.addInviteRecord(userParam.getInviteUserId(), userId, userParam.getInviteType());
            RecordWechatParam recordWechatParam = new RecordWechatParam();
            recordWechatParam.setUserId(userParam.getInviteUserId());
            recordWechatParam.setWechatUid(userParam.getUnionId());
            recordWechatParam.setWechatImg(userParam.getHeadImg());
            recordWechatParam.setWechatName(userParam.getNickName());
            log.debug("\u6dfb\u52a0VIP\u9080\u8bf7\u8bb0\u5f55: \u9080\u8bf7\u4eba\uff1a[{}], \u53d7\u9080\u4eba\uff1a[{}]", (Object)userParam.getInviteUserId(), (Object)userParam.getUnionId());
            this.vipIntegrationService.saveTempViewRecord(recordWechatParam);
        }
    }

    private User convertUser(TempUserParam tempUserParam, User user) {
        user.setWeixin(tempUserParam.getUnionId());
        user.setNickname(tempUserParam.getNickName());
        user.setHeadImg(tempUserParam.getHeadImg());
        Long userId = user.getId() == null ? Long.valueOf(this.nextId()) : user.getId();
        String headImg = this.getImageFromUrl(tempUserParam.getHeadImg(), userId);
        if (StringUtils.isNotEmpty((CharSequence)headImg)) {
            user.setHeadImg(headImg);
        }
        user.setSex(tempUserParam.getSex());
        user.setRegIp(tempUserParam.getRegIp());
        user.setRegisterClient(tempUserParam.getPlatform());
        user.setRegisteredAddress(tempUserParam.getRegisteredAddress());
        user.setRelationId(tempUserParam.getRelationId());
        user.setInviteUserId(tempUserParam.getInviteUserId());
        User inviteUser = this.userMapper.selectByPrimaryKey(tempUserParam.getInviteUserId());
        if (inviteUser == null) {
            this.logger.info("\u53d7\u9080\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a", (Object)user.getId(), (Object)tempUserParam);
            user.setInviteLevel(Integer.valueOf(1));
        } else {
            this.logger.info("\u521b\u5efa\u9080\u8bf7\u7528\u6237[{}]\u7684\u53d7\u9080\u7528\u6237", (Object)inviteUser.getId());
            user.setInviteLevel(Integer.valueOf(inviteUser.getInviteLevel() + 1));
        }
        user.setRegisterChannel(tempUserParam.getInviteType());
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEunm.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setExpiretime(this.getExpireTime());
        Date now = new Date();
        user.setLastLoginTime(now);
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        return user;
    }

    private boolean updateUserInvite(User user, User existedUser) {
        if (null != existedUser && existedUser.getState() == 2 && null == existedUser.getInviteUserId() && user.getInviteUserId() != null) {
            user.setId(existedUser.getId());
            user.setState(existedUser.getState());
            this.userMapper.updateByPrimaryKeySelective(user);
            return true;
        }
        return false;
    }

    private String upLoadHeadImage(Long userId, MultipartFile file) {
        int hashCode = (int)(userId % 10L);
        String url = this.aliyunOSSService.upload(file, "avatar/" + hashCode + "/");
        if (!StringUtils.containsAny((CharSequence)url, (CharSequence)"?")) {
            url = url + "?x-oss-process=style/head";
        }
        return url;
    }

    private boolean bindingCheckParam(LoginInfo loginInfo) {
        if (1 != loginInfo.getType() && 3 != loginInfo.getType() && 2 != loginInfo.getType() && 4 != loginInfo.getType()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)loginInfo.getLoginName())) {
            return false;
        }
        if (1 == loginInfo.getType() && StringUtils.isEmpty((CharSequence)loginInfo.getCode())) {
            return false;
        }
        return 3 != loginInfo.getType() || !StringUtils.isEmpty((CharSequence)loginInfo.getHeadImg()) || !StringUtils.isEmpty((CharSequence)loginInfo.getNickname());
    }

    @Override
    public LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            this.logger.error("\u5b9a\u4f4d\u65f6\u65e0\u6cd5\u63d0\u4f9b\u5730\u533a\u7f16\u7801(\u5b9a\u4f4d\u5931\u8d25)!!!:code:{},userId:{}", (Object)code, (Object)userId);
        }
        if (StringUtils.isNotEmpty((CharSequence)code) && code.length() != 6 && code.length() != 12 || null == userId) {
            this.logger.error("\u53c2\u6570\u9519\u8bef(\u5730\u533a\u7f16\u7801\u4f4d\u6570\u95ee\u9898\u6216\u7528\u6237id\u4e3a\u7a7a):code:{},userId:{}", (Object)code, (Object)userId);
        }
        if (null == code) {
            code = this.bizConfigProperties.getLocationCode();
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(code);
        if (this.appVersionIntegrationService.getPublishState(basicParam).booleanValue()) {
            locationDTO.setEnablePaidPromote(Byte.valueOf((byte)0));
            locationDTO.setEnableCommunityContent(Integer.valueOf(0));
            locationDTO.setEnableIndexPublish(Integer.valueOf(0));
        }
        locationDTO.setPublishPostNum(this.userNewsIntegrationService.getPublishPostNum(userId));
        UserInternalService userInternalService = (UserInternalService)SpringContextHolder.getBean(UserInternalService.class);
        userInternalService.updateUserLocation(locationDTO, userId, code, basicParam.getPlatform());
        if (null != userId) {
            User user = this.userMapper.selectByPrimaryKey(userId);
            user.setLastLoginTime(new Date());
            this.userMapper.updateByPrimaryKeySelective(user);
            if (!this.redisStringAdapter.hasKey(RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)userId)).booleanValue()) {
                this.userAccountService.updateInviteUserCash(userId, ExtraInviteStateEnum.LOGIN_TWICE);
            }
        }
        return locationDTO;
    }

    @Override
    @Async
    public void updateUserLocation(LocationDTO locationDTO, Long userId, String code, int platform) {
        User user;
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && (StringUtils.notEquals((CharSequence)user.getLocationCode(), (CharSequence)locationDTO.getCode()) || StringUtils.notEquals((CharSequence)user.getLocationCode(), (CharSequence)locationDTO.getCode()))) {
            user.setLocationCode(locationDTO.getCode());
            user.setLocationName(locationDTO.getName());
            this.userMapper.updateByPrimaryKeySelective(user);
            this.bizLogIntegrationService.changeArea(userId, code, null);
            UserInfoDTO dto = this.convertUserToDTO(user);
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
            UserLocationHistory lastUserLocation = this.userLocationHistoryMapper.getLastLocationByUser(userId);
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(this.nextSequence());
            userLocationHistory.setLocationCode(locationDTO.getCode());
            userLocationHistory.setUserId(userId);
            this.userLocationHistoryMapper.insert(userLocationHistory);
            if (lastUserLocation == null || !lastUserLocation.getLocationCode().equals(locationDTO.getCode())) {
                this.logger.debug("[updateUserLocation]\u66f4\u65b0\u7528\u6237\u7684\u5730\u7406\u4f4d\u7f6e\uff0c\u5982\u679c\u5386\u53f2\u5b9a\u4f4d\u4e3a\u7a7a\uff0c\u6216\u8005\u4e0e\u5386\u53f2\u5b9a\u4f4d\u4e0d\u4e00\u81f4\uff0c\u5220\u9664\u7528\u6237\u6df7\u5408\u63a8\u8350\u7f13\u5b58,\u539f\u5b9a\u4f4d\u4fe1\u606f:{},\u73b0\u5b9a\u4f4d\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)lastUserLocation), (Object)locationDTO.getCode());
                this.recommendIntegrationService.cleanMixRecommendCache(userId, Integer.valueOf(platform));
            }
        }
    }

    @Override
    public void savePush(PushParam pushParam) {
        User user;
        User userForPush = this.userMapper.findByPushToken(pushParam.getPushToken());
        if (null != userForPush) {
            this.userMapper.clearPushInfo(userForPush.getId().longValue());
        }
        if (null != (user = this.userMapper.selectByUserId(pushParam.getUserId().longValue()))) {
            PushInfo pushInfo = new PushInfo();
            BeanUtils.copyProperties((Object)pushParam, (Object)pushInfo);
            this.userMapper.savePushInfo(pushInfo);
        }
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList(Integer num) {
        return this.userMapper.getVirtualUserList(num);
    }
}

