package com.bxm.localnews.user.account;

import com.bxm.localnews.user.dto.AccountCashFlowDTO;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.param.AccountCashFlowPageParam;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.newidea.component.vo.PageWarper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 现金流水相关的服务接口
 * @author zhaoyadong 2019/3/5 22:12
 */
public interface CashFlowService {

    /**
     * 获取用户最近7天的每天收入信息
     */
    List<UserDayCashDTO> getRecentSevenDayCashFlowByUser(Long userId);

    List<CashFlowDTO> getUserAllCashFlow(CashFlowParam cashFlowParam);

    /**
     * 保存用户现金流水信息
     * @param cashFlow 流水信息
     * @return 影响行数（大于0表示插入成功）
     */
    int addCashFlow(CashFlow cashFlow);

    /**
     * 获取账户自己的赏金金额
     */
    BigDecimal getMySelfBounty(Long userId);

    BigDecimal getMyRedPacket(Long userId);

    /**
     * 是否出现引导体现弹窗(判断用户是否在app外领取了新用户赏金,其他约束条件在客户端完成)
     * @param userId 用户id
     */
    boolean enableWithdraw(Long userId);

    /**
     * 分页查询现金流水信息
     * @param param 分页参数
     * @return 现金流水信息列表
     */
    PageWarper<AccountCashFlowDTO> queryCashByPage(AccountCashFlowPageParam param);
}
