package com.bxm.localnews.user.account;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.TransformParam;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.vo.Message;

import java.math.BigDecimal;

/**
 * 用户账号服务接口
 * @author zhaoyadong 2019/3/5 22:13
 * @desc
 */
public interface UserAccountService {

    /**
     * 获取用户累计余额
     */
    BigDecimal getUserTotalCash(Long userId);

    /**
     * 获取账户详细信息
     */
    UserAccount getUserAccountDetail(Long userId);

    /**
     * 创建用户账户
     */
    Message createUserAccount(Long userId);

    /**
     * 获取用户账户信息
     * 账号信息会进行缓存
     */
    UserAccountDTO getUserAccount(Long userId);

    /**
     * 获取用户账户信息以及是否可提现弹窗
     * @param userId 用户id
     * @return 用户账户信息
     */
    UserAccountDTO getUserAccountAndEnableWithdraw(Long userId);

    /**
     * 获取用户账户信息及其对应7天的收入
     */
    UserAccountDayCashDTO getUserAccountAndDetail(Long userId, String areaCode);

    /**
     * 获取用户对应现金金额和金币
     */
    UserCashGoldDTO getUserCashGold(Long userId);

    /**
     * 修改用户金额
     * @deprecated 使用 {@link com.bxm.localnews.user.account.impl.AccountHandlerProxy}
     */
    @Deprecated
    Boolean addCash(AccountCashParam param);

    /**
     * 用户金额转化
     * @deprecated 使用 {@link com.bxm.localnews.user.account.impl.AccountHandlerProxy}
     */
    @Deprecated
    Boolean transferCash(AccountCashParam param);

    /**
     * 获取账户可提现金额
     */
    BigDecimal getUserDrawableCash(Long userId);

    /**
     * 更新账户提现相关信息
     * @param userId 用户id
     * @param amount 提现金额
     * @param state  提现状态
     */
    Message updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte state);

    /**
     * 修改账户金币信息
     * @deprecated 使用 {@link com.bxm.localnews.user.account.impl.AccountHandlerProxy}
     */
    @Deprecated
    Boolean addGold(AccountGoldParam param);

    /**
     * 获取用户可用的金币
     */
    Integer getUserUsableGold(Long userId);

    /**
     * 用户提现弹窗上报
     */
    void userWithdrawPop(Long userId);

    /**
     * 小程序提现
     */
    Json<BigDecimal> userGoldWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip);

    /**
     * 获取用户及邀请人已获得金额信息
     */
    UserCashInfoVo getUserCashInfo(Long userId);

    /**
     * 更新邀请人金额
     * @param userId           被邀请人id
     * @param currentStateEnum 当前操作状态：1 提现 2 第二天登录
     */
    void updateInviteUserCash(Long userId, ExtraInviteStateEnum currentStateEnum);

    /**
     * 获取账户临时金额
     */
    BigDecimal getAccountTempCash(Long userId);

    /**
     * 将小红花赠与某人
     */
    BigDecimal presentFlower(TransformParam transformParam);

    /**
     * 清空用户的账号缓存信息
     * @param userId 用户ID
     */
    void cleanCache(Long userId);
}
