package com.bxm.localnews.user.account;

import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.vo.WithdrawFlow;

import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/6 10:18
 * @desc
 */
public interface UserWithdrawService {

    /**
     * 获取用户最后一笔的提现订单信息
     */
    UserWithdrawDTO getUserRecentWithdrawInfo(Long userId);

    /**
     * 获取提现信息
     */
    WithdrawFlow getWithdrawFlowById(Long id);

    /**
     * 获取小程序用户对应类型的当天提现记录
     */
    BigDecimal getMiniAppUserWithdraw(Long userId, String openId, Byte state);
}
