package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.account.UserAmountService;
import com.bxm.localnews.user.constant.CashFlowClassifyEnum;
import com.bxm.localnews.user.dto.AccountIncomeDTO;
import com.bxm.localnews.user.dto.AccountIncomeTypeDTO;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by Administrator on 2018/2/23.
 */
@Deprecated
@Service("userAmountService")
public class UserAmountServiceImpl extends BaseService implements UserAmountService {

    @Resource
    private UserAccountService userAccountService;

    @Override
    public UserAmount findAmountByUserId(Long userId) {
        UserAccount userAccount = userAccountService.getUserAccountDetail(userId);
        return convertUserAccount(userAccount);
    }

    @Override
    public AccountIncomeDTO getCashIncome(Long userId) {
        UserAccountDTO userAccount = userAccountService.getUserAccount(userId);

        return AccountIncomeDTO.builder()
                .drawablelCash(userAccount.getDrawablelCash())
                .estimateCash(userAccount.getEstimateCash())
                .noSettlementCash(userAccount.getNoSettlementCash())
                .settledCash(userAccount.getSettledCash())
                .incomeTypes(buildTypes(userAccount))
                .build();
    }

    /**
     * 构建当前配置的流水收益类型
     *
     * @param userAccount
     * @return
     */
    private List<AccountIncomeTypeDTO> buildTypes(UserAccountDTO userAccount) {
        CashFlowClassifyEnum[] classifyEnums = CashFlowClassifyEnum.values();
        List<AccountIncomeTypeDTO> types = Lists.newArrayList();

        for (CashFlowClassifyEnum classifyEnum : classifyEnums) {
            AccountIncomeTypeDTO type = AccountIncomeTypeDTO.builder()
                    .cashFlowLabel(classifyEnum.getLabel())
                    .cashFlowCode(classifyEnum.name())
                    .amount(classifyEnum.getAccountField(userAccount))
                    .build();

            //购物收益需要额外显示订单列表
            boolean showOrder = classifyEnum.equals(CashFlowClassifyEnum.REBATE);
            boolean showGuide = classifyEnum.equals(CashFlowClassifyEnum.ALL) || classifyEnum.equals(CashFlowClassifyEnum.REBATE);

            type.setShowOrder(showOrder);
            type.setShowGuide(showGuide);

            types.add(type);
        }

        return types;
    }

    /**
     * 转换账户信息
     */
    private UserAmount convertUserAccount(UserAccount userAccount) {
        UserAmount userAmount = new UserAmount();
        userAmount.setId(userAccount.getId());
        userAmount.setUserId(userAccount.getUserId());
        userAmount.setState(userAccount.getState());
        userAmount.setJbBalance(BigDecimal.valueOf(userAccount.getUsableGold()));
        userAmount.setTotalJbBalance(BigDecimal.valueOf(userAccount.getTotalGold()));
        userAmount.setRmbBalance(userAccount.getTempCash().add(userAccount.getStabilizeCash())
                .add(userAccount.getDrawableCash()));
        userAmount.setTotalRmbBalance(userAccount.getTotalCash());
        userAmount.setUdpateTime(userAccount.getModifyTime());
        return userAmount;
    }
}
