package com.bxm.localnews.user.account.impl.callback;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;

/**
 * 账号处理过程中的回调接口，支持调用方在处理过程中进行额外的操作
 * @author liujia
 * @date 2020/05/04 11:04
 */
public interface IAccountActionCallback {

    /**
     * 账号处理之前
     */
    default void preAction(AccountActionContext context) {
    }

    /**
     * 账号信息处理之后
     */
    default void postAction(AccountActionContext context) {
    }

    /**
     * 处理失败后
     */
    default void failed(AccountActionContext context) {
    }

    /**
     * 发生异常时
     */
    default void exception(AccountActionContext context) {
    }

    /**
     * 每次重试之前
     */
    default void preRetry(AccountActionContext context) {
    }
}
