package com.bxm.localnews.user.account.impl.handler;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 默认的处理器，当请求设置错误的时候进行兼容，输出日志提示粗心的调用者
 * @author liujia
 * @date 2020/05/04 14:31
 */
@Slf4j
public class DefaultAccountActionHandler implements IAccountActionHandler {

    @Override
    public void handle(AccountActionContext context) {
        log.warn("请求处理的Action:{}未找到对应的ActionHandler，请实现一个对应的"
                        + "com.bxm.localnews.user.account.impl.handler.IAccountActionHandler并注册到 SpringContext",
                context.getAction());
    }

    @Override
    public AccountActionEnum support() {
        return null;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
