package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 增加用户的购物佣金
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class AddRebateCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //购物佣金增加
        storage.setRebateCash(add(source.getRebateCash(), context.getAmount()));
        //待结算金额增加
        storage.setNoSettlementCash(add(source.getNoSettlementCash(), context.getAmount()));
        //总金额增加
        storage.setTotalCash(add(source.getTotalCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        // 待结算时佣金暂时不显示
        return true;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_REBATE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
