package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 增加用户临时金额
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class AddTempCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //临时金额增加
        storage.setTempCash(add(source.getTempCash(), context.getAmount()));

        //总赏金增加
        storage.setTotalCash(add(context.getAmount(), source.getTotalCash()));
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_TEMP_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
