package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.DrawableCashEnoughRule;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 可提现金额转化为提现中
 *
 * @author liujia
 * @date 2020/05/04 18:21
 */
@Component
public class Drawable2WithdrawalAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //可用金额扣除
        storage.setDrawableCash(sub(source.getDrawableCash(), context.getAmount()));
        //提现中金额增加
        storage.setWithdrawalOfCash(add(source.getWithdrawalCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        return false;
    }

    @Override
    boolean isConsume() {
        return true;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.DRAWABLE_TO_WITHDRAWAL;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return Lists.newArrayList(DrawableCashEnoughRule.class);
    }
}
