package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 扣除用户的购物佣金
 * 用户淘客订单退单后会产生
 *
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class SubRebateCashAccountActionHandler extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //购物佣金扣除
        storage.setRebateCash(sub(source.getRebateCash(), context.getAmount()));

        //待结算金额扣除
        storage.setNoSettlementCash(sub(source.getNoSettlementCash(), context.getAmount()));

        //总金额扣除
        storage.setTotalCash(sub(source.getTotalCash(), context.getAmount()));
    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }

    @Override
    boolean isConsume() {
        //流水线上为负数
        return true;
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.SUB_REBATE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}
