package com.bxm.localnews.user.account.impl.handler.gold;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.bxm.localnews.user.enums.AccountActionEnum.ADD_TEMP_GOLD;

/**
 * 给用户添加临时金币
 * @author liujia
 * @date 2020/05/04 14:35
 */
@Component
public class AddTempGoldAccountActionHandler extends AbstractGoldAccountActionHandler {

    @Override
    public AccountActionEnum support() {
        return ADD_TEMP_GOLD;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //临时金币增加
        storage.setTempGold(source.getTempGold() + context.getGoldNum());
        //总金币增加
        storage.setTotalGold(source.getTotalGold() + context.getGoldNum());
    }
}
