package com.bxm.localnews.user.account.impl.handler.gold;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.account.impl.rule.MaxAcquiredGoldRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.bxm.localnews.user.enums.AccountActionEnum.ADD_USABLE_GOLD;

/**
 * 给用户添加可用金币
 * 增加： 可用金币
 * 增加： 总金币数
 * @author liujia
 * @date 2020/05/04 14:35
 */
@Component
public class AddUsableGoldAccountActionHandler extends AbstractGoldAccountActionHandler {

    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        //可用金币增加
        storage.setUsableGold(source.getUsableGold() + context.getGoldNum());
        //总金币增加
        storage.setTotalGold(source.getTotalGold() + context.getGoldNum());
    }

    @Override
    public AccountActionEnum support() {
        return ADD_USABLE_GOLD;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return Lists.newArrayList(MaxAcquiredGoldRule.class);
    }
}
